package org.phosphoresce.webcore.ext.dynapage;

import java.io.File;
import java.io.PrintWriter;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.phosphoresce.lib.commons.util.PropertiesUtil;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.phosphoresce.webcore.ext.dynapage.model.AbstractModel;
import org.phosphoresce.webcore.ext.dynapage.test.TestModelFactory;
import org.slf4j.LoggerFactory;

/**
 * 動的ページ構築アドオン環境初期化クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2011/12/24	Kitagawa		新規作成
 *-->
 */
public class DynapageConfiguration implements DynapageConstants {

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(DynapageConfiguration.class));

	/**
	 * コンストラクタ<br>
	 */
	private DynapageConfiguration() {
		super();
	}

	/**
	 * 動的ページ構築アドオンの初期化処理を行います。<br>
	 * 当初期化処理はアプリケーション共通初期化処理が完了されていることが前提となります。<br>
	 */
	public synchronized static void configure() {
		try {
			log.output("FDYP00001");

			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
			VelocityEngine engine = new VelocityEngine(PropertiesUtil.load(DYNAPAGE_VELOCITY_CONFIG));
			engine.init();

			TestModelFactory factory = new TestModelFactory();
			AbstractModel model = factory.createNormalPage();

			Template template = engine.getTemplate(model.getTemplate());

			VelocityContext context = new VelocityContext();
			context.put("data", model);

			File file = new File("workspace\\Phosphoresce_Webcore\\content\\test.jsp");

			PrintWriter writer = new PrintWriter(file, "UTF-8");

			template.merge(context, writer);

			writer.flush();
			writer.close();

			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST
			// TODO TESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTESTTEST

			log.output("FDYP00002");
		} catch (Throwable e) {
			log.output(e, "FDYP00004");
		}
	}

	/**
	 * 動的ページ構築アドオンの破棄処理を実行します。<br>
	 * @throws Throwable 終了処理中に予期せぬエラーが発生した場合にスローされます 
	 */
	public synchronized static void destroy() throws Throwable {
		log.output("FDYP00003");
	}
}
