package org.phosphoresce.webcore.core.transaction;

import java.util.Date;

/**
 * トランザクション処理コンテキストクラス<br>
 * <br>
 * データベーストランザクション処理を行う際の情報を管理するコンテキストクラスです。<br>
 * JDBCやO/Rマッパー等の各種サブトランザクションモジュールはこれを利用することでインタフェースを統一します。<br>
 * 
 * @param <T> トランザクションマネージャクラス 
 * @param <U> トランザクション処理ユーザークラス
 *  
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/05	Kitagawa		新規作成
 *-->
 */
public class TransactionContext<T extends TransactionManager, U extends TransactionUser> {

	/** トランザクション管理オブジェクト */
	private T transaction;

	/** トランザクション実行ユーザー */
	private U processUser;

	/** 処理時刻 */
	private Date processDate;

	/**
	 * コンストラクタ<br>
	 * @param transaction トランザクション管理オブジェクト
	 * @param processUser トランザクション実行ユーザー
	 * @param processDate 処理時刻
	 */
	public TransactionContext(T transaction, U processUser, Date processDate) {
		super();
		this.transaction = transaction;
		this.processUser = processUser;
		this.processDate = processDate;
	}

	/**
	 * トランザクション管理オブジェクトを取得します。<br>
	 * @return トランザクション管理オブジェクト
	 */
	public final T getTransaction() {
		return transaction;
	}

	/**
	 * トランザクション実行ユーザーを取得します。<br>
	 * @return トランザクション実行ユーザー
	 */
	public final U getProcessUser() {
		return processUser;
	}

	/**
	 * 処理時刻を取得します。<br>
	 * @return 処理時刻
	 */
	public final Date getProcessDate() {
		return processDate;
	}
}
