package org.phosphoresce.webcore.core.servlet.filter;

import java.io.IOException;
import java.util.Date;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.phosphoresce.lib.commons.util.ExceptionUtil;
import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.Environment;
import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * 例外発生時フィルタクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/06	Kitagawa		新規作成
 *-->
 */
public class ExceptionFilter implements Filter, GlobalConstants {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/** サーブレットコンテキストオブジェクト */
	private ServletContext context;

	/**
	 * コンストラクタ<br>
	 */
	public ExceptionFilter() {
		super();
	}

	/**
	 * フィルタの初期化処理を実行します。<br>
	 * @param config 環境設定オブジェクト
	 * @throws ServletException 初期化処理に失敗した場合にスローされます
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		this.context = config.getServletContext();
	}

	/**
	 * フィルタの破棄処理を実行します。<br>
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

	/**
	 * フィルタ処理を実行します。<br>
	 * @param servletRequest リクエストオブジェクト
	 * @param servletResponse レスポンスオブジェクト
	 * @param chain フィルタチェーンオブジェクト
	 * @throws IOException フィルタ処理中に入出力例外が発生した場合にスローされます
	 * @throws ServletException フィルタ処理中に予期せぬエラーが発生した場合にスローされます
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
		try {
			chain.doFilter(servletRequest, servletResponse);
		} catch (Throwable e) {
			log.output(e, "FCRE00056");
			servletRequest.setAttribute(REQUEST_ATTR_KEY_PROCESSDATE, new Date());
			servletRequest.setAttribute(REQUEST_ATTR_KEY_ENVIRONMENT, Environment.getMap());
			servletRequest.setAttribute(REQUEST_ATTR_KEY_CONFIG, Config.getMap());
			servletRequest.setAttribute(REQUEST_ATTR_KEY_REQUEST, servletRequest);
			servletRequest.setAttribute(REQUEST_ATTR_KEY_EXCEPTION, e);
			servletRequest.setAttribute(REQUEST_ATTR_KEY_EXCEPTION_TRACE, ExceptionUtil.getStackTraceValue(e));
			RequestDispatcher dispatcher = context.getRequestDispatcher(Config.getString(ConfigName.COMMON_JSP_SYSTEMERROR));
			dispatcher.forward(servletRequest, servletResponse);
		}
	}
}
