package org.phosphoresce.webcore.core.servlet.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.GlobalConstants;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.config.StringResource;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * エンコーディングフィルタクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/08	Kitagawa		新規作成
 *-->
 */
public class EncodingFilter implements Filter, GlobalConstants {

	/** ロガーオブジェクト */
	private CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(getClass()));

	/**
	 * コンストラクタ<br>
	 */
	public EncodingFilter() {
		super();
	}

	/**
	 * フィルタの初期化処理を実行します。<br>
	 * @param config 環境設定オブジェクト
	 * @throws ServletException 初期化処理に失敗した場合にスローされます
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
	}

	/**
	 * フィルタの破棄処理を実行します。<br>
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

	/**
	 * フィルタ処理を実行します。<br>
	 * @param servletRequest リクエストオブジェクト
	 * @param servletResponse レスポンスオブジェクト
	 * @param chain フィルタチェーンオブジェクト
	 * @throws IOException フィルタ処理中に入出力例外が発生した場合にスローされます
	 * @throws ServletException フィルタ処理中に予期せぬエラーが発生した場合にスローされます
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) servletRequest;
		HttpServletResponse response = (HttpServletResponse) servletResponse;

		// キャラクタセット設定
		try {
			request.setCharacterEncoding(Config.getString(ConfigName.COMMON_CHARSET_DEFAULT));
		} catch (Throwable e) {
			log.output(e, "FCRE00027");
			throw new ServletException(StringResource.getString("FCRE00027"), e);
		}

		// フィルタチェーン
		chain.doFilter(request, response);
	}
}
