package org.phosphoresce.webcore.core.servlet;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.phosphoresce.lib.commons.util.ResourceUtil;
import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.config.StringResource;

/**
 * JavaScript用メッセージ一覧定数出力サーブレットクラス<br>
 * <br>
 * サーバーサイドメッセージリソースで定義されているメッセージをJavascriptメッセージで利用可能とするサーブレットクラスです。<br>
 * 当クラスを呼び出すことで以下の内容をクライアントにレスポンスし、クライアントはJavascriptのMessagesクラスでサーバーサイドで
 * 定義されたメッセージリソースの内容を利用することが可能となります。<br>
 * <pre>
 * var Message = function() {};
 * Message.get = function(code, binds) {};
 * Message.MESSAGES["メッセージコード"] = "メッセージ内容";
 * Message.MESSAGES["メッセージコード"] = "メッセージ内容";
 * Message.MESSAGES["メッセージコード"] = "メッセージ内容";
 * ...
 * </pre>
 * 
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/05	Kitagawa			新規作成
 *-->
 */
public class JavascriptMessageServlet extends HttpServlet {

	/** Javascriptソース */
	private String javascript;

	/**
	 * サーブレットを初期化します。<br>
	 * @see javax.servlet.GenericServlet#init()
	 */
	@Override
	public void init() throws ServletException {
		super.init();
		try {
			javascript = ResourceUtil.getText(getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + "JavascriptMessageServlet.js", "UTF-8");
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}

	/**
	 * GETリクエストを処理します。<br>
	 * @param request リクエストオブジェクト
	 * @param response レスポンスオブジェクト
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// super.doGet(request, response);
		doProcess(request, response);
	}

	/**
	 * POSTリクエストを処理します。<br>
	 * @param request リクエストオブジェクト
	 * @param response レスポンスオブジェクト
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// super.doPost(request, response);
		doProcess(request, response);
	}

	/**
	 * メッセージリソースを元にJavaScriptメッセージ定数コードをレスポンスします。<br>
	 * @param request リクエストオブジェクト
	 * @param response レスポンスオブジェクト
	 * @throws IOException レスポンス出力時に入出力例外が発生した場合にスローされます
	 */
	private void doProcess(HttpServletRequest request, HttpServletResponse response) throws IOException {
		response.setHeader("Content-Type", "text/javascript");
		response.setContentType("text/javascript");
		response.addHeader("Cache-Control", "no-cache");
		response.setCharacterEncoding(Config.getString(ConfigName.COMMON_CHARSET_DEFAULT));

		PrintWriter writer = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), Config.getString(ConfigName.COMMON_CHARSET_DEFAULT)));
		writer.println(javascript);
		for (String key : StringResource.keys()) {
			String code = key.replaceAll("-.*", "");
			String message = StringResource.getString(key);
			message = message.replaceAll("\n", "\\\\n");
			message = message.replaceAll("\"", "\\\"");
			String source = "Message.MESSAGES[\"" + code + "\"] = \"" + message + "\";";
			writer.println(source);
			writer.flush();
		}
		writer.flush();
		writer.close();
	}
}
