package org.phosphoresce.webcore.core.exception;


/**
 * アプリケーションコアモジュール例外クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class WebcoreCoreModuleException extends WebcoreCriticalException {

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param cause 例外要因
	 */
	public WebcoreCoreModuleException(String code, Throwable cause) {
		super(code, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージコード
	 * @param binds 例外メッセージバインドオブジェクト
	 * @param cause 例外要因
	 */
	public WebcoreCoreModuleException(String code, Object[] binds, Throwable cause) {
		super(code, binds, cause);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 */
	public WebcoreCoreModuleException(String code) {
		super(code);
	}

	/**
	 * コンストラクタ<br>
	 * @param code 例外メッセージ
	 * @param binds 例外メッセージバインドオブジェクト
	 */
	public WebcoreCoreModuleException(String code, Object[] binds) {
		super(code, binds);
	}
}
