package org.phosphoresce.webcore.core.daemon;

import org.phosphoresce.webcore.core.ConfigName;
import org.phosphoresce.webcore.core.config.Config;
import org.phosphoresce.webcore.core.logger.CodeConvertLogger;
import org.slf4j.LoggerFactory;

/**
 * ガベージコレクションデーモンスレッド<br>
 * <br>
 * 環境定義された実行間隔に基づいて強制的にガベージコレクションを定期実行するスレッドクラスです。<br>
 * 当スレッドクラスによるガベージコレクションの強制実行が不要な場合は環境定義において処理不要フラグを設定します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/12/21	Kitagawa		新規作成
 *-->
 */
public class GarbageCollectionDaemon extends Thread {

	/** セルフインスタンス */
	private static GarbageCollectionDaemon instance;

	/** ロガーオブジェクト */
	private static CodeConvertLogger log = new CodeConvertLogger(LoggerFactory.getLogger(GarbageCollectionDaemon.class));

	/** 処理ループフラグ */
	private boolean loop;

	/**
	 * コンストラクタ<br>
	 */
	private GarbageCollectionDaemon() {
		super(new Runnable() {
			@Override
			public void run() {
				GarbageCollectionDaemon.instance.loop = true;
				while (GarbageCollectionDaemon.instance.loop) {
					Runtime.getRuntime().gc();
					log.output("FCRE00033");
					try {
						sleep(Config.getLong(ConfigName.COMMON_DAEMON_GC_INTERVAL));
					} catch (InterruptedException e) {
						// 割り込み例外は無視
					}
				}
				GarbageCollectionDaemon.instance = null;
			}
		});
	}

	/**
	 * デーモンサービスを開始します。<br>
	 */
	public static void execute() {
		if (instance != null) {
			return;
		}
		instance = new GarbageCollectionDaemon();
		instance.start();
	}

	/**
	 * デーモンサービスを停止します。<br>
	 */
	public static void stopDaemon() {
		if (instance == null) {
			return;
		}
		instance.loop = false;
		instance.interrupt();
	}
}
