package org.phosphoresce.webcore.core.config;

import java.util.Properties;

import org.phosphoresce.lib.commons.util.StringUtil;

/**
 * アプリケーション文字列定義レベルクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/06	Kitagawa		新規作成
 *-->
 */
public final class StringResourceLevel {

	/** レベル指定なし */
	public static final StringResourceLevel NONE = new StringResourceLevel("");

	/** 情報レベル */
	public static final StringResourceLevel INFO = new StringResourceLevel("-I");

	/** エラーレベル */
	public static final StringResourceLevel ERROR = new StringResourceLevel("-E");

	/** 警告レベル */
	public static final StringResourceLevel WARN = new StringResourceLevel("-W");

	/** 連絡レベル */
	public static final StringResourceLevel NOTICE = new StringResourceLevel("-N");

	/** デバッグレベル */
	public static final StringResourceLevel DEBUG = new StringResourceLevel("-D");

	/** トレースレベル */
	public static final StringResourceLevel TRACE = new StringResourceLevel("-T");

	/** サフィックス */
	private String suffix;

	/**
	 * コンストラクタ<br>
	 * @param suffix サフィックス
	 */
	private StringResourceLevel(String suffix) {
		super();
		this.suffix = suffix;
	}

	/**
	 * 指定されたメッセージコードから実際の定義コードに変換して取得ます。<br>
	 * @param code メッセージコード
	 * @return メッセージレベルが付与された実際の定義コード
	 */
	public static String getDefinitionCode(String code) {
		Properties properties = StringResource.getProperties();
		if (StringUtil.isEmpty(code)) {
			return "";
		}
		if (properties.containsKey(code + INFO.suffix)) {
			return code + INFO.suffix;
		} else if (properties.containsKey(code + ERROR.suffix)) {
			return code + ERROR.suffix;
		} else if (properties.containsKey(code + WARN.suffix)) {
			return code + WARN.suffix;
		} else if (properties.containsKey(code + NOTICE.suffix)) {
			return code + NOTICE.suffix;
		} else if (properties.containsKey(code + DEBUG.suffix)) {
			return code + DEBUG.suffix;
		} else if (properties.containsKey(code + TRACE.suffix)) {
			return code + TRACE.suffix;
		} else {
			return code + NONE.suffix;
		}
	}

	/**
	 * 指定されたメッセージコードから実際の定義コードレベルを取得します。<br>
	 * @param code メッセージコード
	 * @return メッセージレベルが付与された実際の定義コードレベル
	 */
	public static StringResourceLevel getDefinitionLevel(String code) {
		Properties properties = StringResource.getProperties();
		if (StringUtil.isEmpty(code)) {
			return NONE;
		}
		if (properties.containsKey(code + INFO.suffix)) {
			return INFO;
		} else if (properties.containsKey(code + ERROR.suffix)) {
			return ERROR;
		} else if (properties.containsKey(code + WARN.suffix)) {
			return WARN;
		} else if (properties.containsKey(code + NOTICE.suffix)) {
			return NOTICE;
		} else if (properties.containsKey(code + DEBUG.suffix)) {
			return DEBUG;
		} else if (properties.containsKey(code + TRACE.suffix)) {
			return TRACE;
		} else {
			return NONE;
		}
	}
}
