package org.phosphoresce.webcore.core;

/**
 * アプリケーション定数インタフェース<br>
 * <br>
 * フレームワークにおける共通の定数が定義されます。<br>
 * 各サブフレームワークモジュールはこれを継承した定数をそれぞれ設けることが推奨されます。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public interface GlobalConstants {

	/** 空文字列 */
	public static final String EMPTY_STRING = "";

	/** ディフォルトメッセージリソースバンドル */
	public static final String DEFAULT_MESSAGE_RESOURCE_BUNDLE = "application";

	/** リクエストアトリビュートキー(アプリケーション実行時刻) */
	public static final String REQUEST_ATTR_KEY_PROCESSDATE = "processDate";

	/** リクエストアトリビュートキー(アプリケーション環境情報オブジェクト) */
	public static final String REQUEST_ATTR_KEY_ENVIRONMENT = "environment";

	/** リクエストアトリビュートキー(アプリケーション環境定義オブジェクト) */
	public static final String REQUEST_ATTR_KEY_CONFIG = "config";

	/** リクエストアトリビュートキー(リクエストオブジェクト) */
	public static final String REQUEST_ATTR_KEY_REQUEST = "request";

	/** リクエストアトリビュートキー(例外オブジェクト) */
	public static final String REQUEST_ATTR_KEY_EXCEPTION = "exception";

	/** リクエストアトリビュートキー(例外トレース情報) */
	public static final String REQUEST_ATTR_KEY_EXCEPTION_TRACE = "exceptionTrace";

	/** リクエストアトリビュートキー(ステータスコード) */
	public static final String REQUEST_ATTR_KEY_STATUS_CODE = "statusCode";
}
