package org.phosphoresce.webcore.ext.struts.sample.function.FS00001;

import org.phosphoresce.webcore.ext.hibernate4.model.SUser;
import org.phosphoresce.webcore.ext.hibernate4.transaction.HibernateTransactionManager;
import org.phosphoresce.webcore.ext.struts.action.Forward;
import org.phosphoresce.webcore.ext.struts.action.ServletContainer;
import org.phosphoresce.webcore.ext.struts.action.WindowSessionContainer;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsAction;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsMethod;
import org.phosphoresce.webcore.ext.struts.annotation.StrutsTransaction;
import org.phosphoresce.webcore.ext.struts.sample.common.action.SampleAction;
import org.phosphoresce.webcore.ext.struts.sample.common.action.SampleForm;

/**
 * サンプル機能アクションクラス(ログイン画面)<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2010/07/03	Kitagawa		新規作成
 *-->
 */
public class FS00001Action extends SampleAction implements FS00001Constants {

	/**
	 * 初期表示処理を行います。<br>
	 * @param form ActionFormオブジェクト
	 * @param session セッションコンテナオブジェクト
	 * @param servlet サーブレットコンテナオブジェクト
	 * @return 遷移先パス
	 * @throws Throwable 処理中に補足されない予期せぬエラーが発生した場合にスローされます
	 * @see org.phosphoresce.webcore.ext.struts.action.AbstractAction#index(org.phosphoresce.webcore.ext.struts.action.AbstractForm, org.phosphoresce.webcore.ext.struts.action.WindowSessionContainer, org.phosphoresce.webcore.ext.struts.action.ServletContainer)
	 */
	@Override
	@StrutsMethod(checkSesion = false, checkLogin = false, transaction = true, namedTransactions = { "test1", "test2" })
	public Forward index(SampleForm form, WindowSessionContainer<SUser> session, ServletContainer<SUser> servlet) throws Throwable {
		FS00001Logic fs00001Logic = createLogic(servlet, FS00001Logic.class);
		System.err.println("************************************** " + fs00001Logic.test());

		return new Forward("FS00001.jsp");
	}

	/**
	 * 例外発生テスト処理を行います。<br>
	 * @param form ActionFormオブジェクト
	 * @param session セッションコンテナオブジェクト
	 * @param servlet サーブレットコンテナオブジェクト
	 * @return 遷移先パス
	 * @throws Throwable 処理中に補足されない予期せぬエラーが発生した場合にスローされます
	 */
	@SuppressWarnings("unused")
	@StrutsMethod(checkSesion = false, checkLogin = false)
	public Forward testException(SampleForm form, WindowSessionContainer<SUser> session, ServletContainer<SUser> servlet) throws Throwable {
		if (true) {
			throw new Exception("テスト例外発生");
		}
		return null;
	}
}
