package org.phosphoresce.lib.poi.print;

/**
 * ヘッダー/フッターフィールド定義列挙型クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
public enum PoiHeaderFooterField {

	/** 定義文字列(シート名) */
	SHEET_NAME_FIELD("&A"),

	/** 定義文字列(日付) */
	DATE_FIELD("&D"),

	/** 定義文字列(ファイルパス) */
	FILE_FIELD("&F"),

	/** 定義文字列(フルファイルパス) */
	FULL_FILE_FIELD("&Z"),

	/** 定義文字列(ページ番号) */
	PAGE_FIELD("&P"),

	/** 定義文字列(時刻) */
	TIME_FIELD("&T"),

	/** 定義文字列(総ページ番号) */
	NUM_PAGES_FIELD("&N"),

	;

	/** 定義値 */
	private String value;

	/**
	 * コンストラクタ<br>
	 * @param value 定義値
	 */
	private PoiHeaderFooterField(String value) {
		this.value = value;
	}

	/**
	 * 定義値を取得します。<br>
	 * @return 定義値
	 */
	public String value() {
		return value;
	}

	/**
	 * クラス情報を文字列として提供します。<br>
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return value;
	}
}
