package org.phosphoresce.lib.poi.print;

import org.phosphoresce.lib.poi.PoiGlobal;

/**
 * シートヘッダ/フッタークラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
public class PoiHeaderFooter implements PoiGlobal {

	/** 文字列バッファ */
	private StringBuilder builder;

	/**
	 * コンストラクタ<br>
	 */
	public PoiHeaderFooter() {
		super();
		this.builder = new StringBuilder();
	}

	/**
	 * コンストラクタ<br>
	 * @param value 初期文字列
	 */
	public PoiHeaderFooter(String value) {
		super();
		this.builder = new StringBuilder();
		this.append(value);
	}

	/**
	 * ヘッダー/フッター文字列を取得します。<br>
	 * @return ヘッダー/フッター文字列
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return builder.toString();
	}

	/**
	 * 指定された文字列を追加します。<br>
	 * @param string 追加文字列
	 * @param decorates 装飾定義
	 * @return クラスインスタンス
	 */
	public PoiHeaderFooter append(String string, PoiHeaderFooterDecorate... decorates) {
		if (decorates != null) {
			for (PoiHeaderFooterDecorate decorate : decorates) {
				builder.append(decorate.value());
			}
		}
		builder.append(string);
		if (decorates != null) {
			for (PoiHeaderFooterDecorate decorate : decorates) {
				builder.append(decorate.value());
			}
		}
		return this;
	}

	/**
	 * 指定された文字列を追加します。<br>
	 * @param string 追加文字列
	 * @return クラスインスタンス
	 */
	public PoiHeaderFooter append(String string) {
		return append(string, (PoiHeaderFooterDecorate[]) null);
	}

	/**
	 * 指定された定義値を追加します。<br>
	 * @param field 定義値
	 * @return クラスインスタンス
	 */
	public PoiHeaderFooter append(PoiHeaderFooterField field, PoiHeaderFooterDecorate... decorates) {
		if (decorates != null) {
			for (PoiHeaderFooterDecorate decorate : decorates) {
				builder.append(decorate.value());
			}
		}
		builder.append(field.value());
		if (decorates != null) {
			for (PoiHeaderFooterDecorate decorate : decorates) {
				builder.append(decorate.value());
			}
		}
		return this;
	}

	/**
	 * 指定された定義値を追加します。<br>
	 * @param field 定義値
	 * @return クラスインスタンス
	 */
	public PoiHeaderFooter append(PoiHeaderFooterField field) {
		return append(field, (PoiHeaderFooterDecorate[]) null);
	}
}
