package org.phosphoresce.lib.poi.dyna;

import org.phosphoresce.lib.poi.PoiGlobal;
import org.phosphoresce.lib.poi.print.PoiPrintConfig;

/**
 * 動的バインド出力情報コンテナクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
class PoiDynaExportContainer implements PoiGlobal {

	/** テンプレートシートインデックス */
	private int templateSheetIndex;

	/** 作成シート名 */
	private String sheetName;

	/** バインドマップ */
	private PoiDynaMap dynaMap;

	/** 印刷設定オブジェクト */
	private PoiPrintConfig printConfig;

	/**
	 * コンストラクタ<br>
	 */
	private PoiDynaExportContainer() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param templateSheetIndex テンプレートシートインデックス
	 * @param sheetName 作成シート名
	 * @param dynaMap バインドマップ
	 * @param printConfig 印刷設定オブジェクト
	 */
	public PoiDynaExportContainer(int templateSheetIndex, String sheetName, PoiDynaMap dynaMap, PoiPrintConfig printConfig) {
		super();
		this.templateSheetIndex = templateSheetIndex;
		this.sheetName = sheetName;
		this.dynaMap = dynaMap;
		this.printConfig = printConfig;
	}

	/**
	 * コンストラクタ<br>
	 * @param templateSheetIndex テンプレートシートインデックス
	 * @param sheetName 作成シート名
	 * @param dynaMap バインドマップ
	 */
	public PoiDynaExportContainer(int templateSheetIndex, String sheetName, PoiDynaMap dynaMap) {
		super();
		this.templateSheetIndex = templateSheetIndex;
		this.sheetName = sheetName;
		this.dynaMap = dynaMap;
	}

	/**
	 * テンプレートシートインデックスを取得します。<br>
	 * @return テンプレートシートインデックス
	 */
	public int getTemplateSheetIndex() {
		return templateSheetIndex;
	}

	/**
	 * テンプレートシートインデックスを設定します。<br>
	 * @param templateSheetIndex テンプレートシートインデックス
	 */
	public void setTemplateSheetIndex(int templateSheetIndex) {
		this.templateSheetIndex = templateSheetIndex;
	}

	/**
	 * 作成シート名を取得します。<br>
	 * @return 作成シート名
	 */
	public String getSheetName() {
		return sheetName;
	}

	/**
	 * 作成シート名を設定します。<br>
	 * @param sheetName 作成シート名
	 */
	public void setSheetName(String sheetName) {
		this.sheetName = sheetName;
	}

	/**
	 * バインドマップを取得します。<br>
	 * @return バインドマップ
	 */
	public PoiDynaMap getDynaMap() {
		return dynaMap;
	}

	/**
	 * バインドマップを設定します。<br>
	 * @param dynaMap バインドマップ
	 */
	public void setDynaMap(PoiDynaMap dynaMap) {
		this.dynaMap = dynaMap;
	}

	/**
	 * 印刷設定オブジェクトを取得します。<br>
	 * @return 印刷設定オブジェクト
	 */
	public PoiPrintConfig getPrintConfig() {
		return printConfig;
	}

	/**
	 * 印刷設定オブジェクトを設定します。<br>
	 * @param printConfig 印刷設定オブジェクト
	 */
	public void setPrintConfig(PoiPrintConfig printConfig) {
		this.printConfig = printConfig;
	}
}
