package org.phosphoresce.lib.jod;


/**
 * LibreOfficeドキュメントコンバート環境設定オブジェクト<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2013/02/07	Kitagawa		新規作成
 *-->
 */
public class JODSetting {

	/** 実行OSタイプ */
	private JODOSType osType;

	/** 接続維持設定 */
	private boolean keepConnect;

	/** 接続試行回数 */
	private int connectTryCount;

	/** 接続試行間隔(ミリ秒) */
	private long connectTryDelay;

	/** LibreOffice実行ファイルパス */
	private String sofficePath;

	/** LibreOffice実行時テンポラリパス */
	private String temporaryPath;

	/** LibreOffice実行ホスト */
	private String sofficeHost;

	/** LibreOffice実行予約ポート(開始) */
	private int sofficeReservePortStart;

	/** LibreOffice実行予約ポート(終了) */
	private int sofficeReservePortEnd;

	/**
	 * コンストラクタ<br>
	 */
	public JODSetting() {
		super();
		this.osType = JODOSType.WINDOWS;
		this.keepConnect = false;
		this.connectTryCount = 5;
		this.connectTryDelay = 1000;
		this.sofficePath = "";
		this.temporaryPath = "";
		this.sofficeHost = "localhost";
		this.sofficeReservePortStart = 81000;
		this.sofficeReservePortEnd = 81000;
	}

	/**
	 * 実行OSタイプを取得します。<br>
	 * @return 実行OSタイプ
	 */
	public JODOSType getOsType() {
		return osType;
	}

	/**
	 * 実行OSタイプを設定します。<br>
	 * @param osType 実行OSタイプ
	 */
	public void setOsType(JODOSType osType) {
		this.osType = osType;
	}

	/**
	 * 接続維持設定を取得します。<br>
	 * @return 接続維持設定
	 */
	public boolean isKeepConnect() {
		return keepConnect;
	}

	/**
	 * 接続維持設定を設定します。<br>
	 * @param keepConnect 接続維持設定
	 */
	public void setKeepConnect(boolean keepConnect) {
		this.keepConnect = keepConnect;
	}

	/**
	 * 接続試行回数を取得します。<br>
	 * @return 接続試行回数
	 */
	public int getConnectTryCount() {
		return connectTryCount;
	}

	/**
	 * 接続試行回数を設定します。<br>
	 * @param connectTryCount 接続試行回数
	 */
	public void setConnectTryCount(int connectTryCount) {
		this.connectTryCount = connectTryCount;
	}

	/**
	 * 接続試行間隔(ミリ秒)を取得します。<br>
	 * @return 接続試行間隔(ミリ秒)
	 */
	public long getConnectTryDelay() {
		return connectTryDelay;
	}

	/**
	 * 接続試行間隔(ミリ秒)を設定します。<br>
	 * @param connectTryDelay 接続試行間隔(ミリ秒)
	 */
	public void setConnectTryDelay(long connectTryDelay) {
		this.connectTryDelay = connectTryDelay;
	}

	/**
	 * LibreOffice実行ファイルパスを取得します。<br>
	 * @return LibreOffice実行ファイルパス
	 */
	public String getSofficePath() {
		return sofficePath;
	}

	/**
	 * LibreOffice実行ファイルパスを設定します。<br>
	 * @param sofficePath LibreOffice実行ファイルパス
	 */
	public void setSofficePath(String sofficePath) {
		this.sofficePath = sofficePath;
	}

	/**
	 * LibreOffice実行時テンポラリパスを取得します。<br>
	 * @return LibreOffice実行時テンポラリパス
	 */
	public String getTemporaryPath() {
		return temporaryPath;
	}

	/**
	 * LibreOffice実行時テンポラリパスを設定します。<br>
	 * @param temporaryPath LibreOffice実行時テンポラリパス
	 */
	public void setTemporaryPath(String temporaryPath) {
		this.temporaryPath = temporaryPath;
	}

	/**
	 * LibreOffice実行ホストを取得します。<br>
	 * @return LibreOffice実行ホスト
	 */
	public String getSofficeHost() {
		return sofficeHost;
	}

	/**
	 * LibreOffice実行ホストを設定します。<br>
	 * @param sofficeHost LibreOffice実行ホスト
	 */
	public void setSofficeHost(String sofficeHost) {
		this.sofficeHost = sofficeHost;
	}

	/**
	 * LibreOffice実行予約ポート(開始)を取得します。<br>
	 * @return LibreOffice実行予約ポート(開始)
	 */
	public int getSofficeReservePortStart() {
		return sofficeReservePortStart;
	}

	/**
	 * LibreOffice実行予約ポート(開始)を設定します。<br>
	 * @param sofficeReservePortStart LibreOffice実行予約ポート(開始)
	 */
	public void setSofficeReservePortStart(int sofficeReservePortStart) {
		this.sofficeReservePortStart = sofficeReservePortStart;
	}

	/**
	 * LibreOffice実行予約ポート(終了)を取得します。<br>
	 * @return LibreOffice実行予約ポート(終了)
	 */
	public int getSofficeReservePortEnd() {
		return sofficeReservePortEnd;
	}

	/**
	 * LibreOffice実行予約ポート(終了)を設定します。<br>
	 * @param sofficeReservePortEnd LibreOffice実行予約ポート(終了)
	 */
	public void setSofficeReservePortEnd(int sofficeReservePortEnd) {
		this.sofficeReservePortEnd = sofficeReservePortEnd;
	}
}
