/**
 * ユニークID管理クラス<br>
 * <br>
 * スクリプト上で利用するユニークなID生成処理を行うインタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var UniqueID = function() {
};

/** 前回生成ユニークID */
UniqueID.prevUniqueId = 0;

/**
 * ユニークIDを生成します。<br>
 * 当メソッドを呼び出す度に常にユニークとなる文字列を提供します。<br>
 * @returns ユニークID文字列
 */
UniqueID.generate = function() {
	var uniquId = new Date().getTime();
	while (this.prevUniqueId === uniquId) {
		uniquId = new Date().getTime();
	}
	prevUniqueId = uniquId;
	return uniquId;
};
