/**
 * スクリプトユーティリティクラス<br>
 * <br>
 * スクリプトクラスに対するユーティリティクラスです。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var ScriptUtil = function() {
};

/**
 * 指定されたスクリプトクラス配置パスを取得します。<br>
 * @param {String} jsfile スクリプトファイルURL
 * @returns {Boolean} スクリプトクラスのURL
 */
ScriptUtil.getScriptPath = function(jsfile) {
	var path = "";
	$("script").each(function() {
		var src = $(this).attr("src");
		if (src) {
			var regexp = new RegExp("(^|.*)(" + (jsfile.replace(new RegExp("\\."), "\\.")) + ".*)$");
			var match = src.match(regexp);
			if (match) {
				var i = src.lastIndexOf("/");
				path = i < 0 ? src : src.substring(0, i);
				return true;
			}
		}
	});
	return path;
};
