/**
 * ドキュメント要素ユーティリティクラス<br>
 * <br>
 * ドキュメント要素に対する操作インタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var LayoutUtil = function() {
};

/**
 * 指定要素を特定の要素全体にリサイズしてフィックスさせます。<br>
 * 当処理ではフィックス先要素zIndex考慮、リサイズ時の考慮は行いません。<br>	
 * @param {Object} target 処理対象要素又はセレクタ文字列
 * @param {Object} dest フィックス先要素又はセレクタ文字列(未指定時はbody要素として実行されます)
 * @returns {Boolean} 正常に処理が終了した場合にtrueを返却
 */
LayoutUtil.fix = function(target, dest) {
	if (!target || target === null) {
		return false;
	}

	/*
	 * フィックス先未指定時、Window、Document時は画面全体フィックス処理とする
	 */
	var viewportFix = false;
	var windowOrDocument = false;
	if (!dest || dest === null) {
		viewportFix = true;
		dest = $(window);
	} else if (typeof Window !== "undefined") {
		if (dest instanceof Window || $(dest)[0] instanceof Window) {
			viewportFix = true;
			windowOrDocument = true;
		}
	} else if (typeof Document !== "undefined") {
		if (dest instanceof Document || $(dest)[0] instanceof Document) {
			viewportFix = true;
			windowOrDocument = true;
		}
	}

	/*
	 * フィックスタイル生成
	 */
	var css = {};
	if (viewportFix) {
		css.position = "fixed";
		css.top = 0;
		css.left = 0;
		css.width = Content.getViewportWidth();
		css.height = Content.getViewportHeight();
	} else {
		css.top = $(dest).css("position") === "relative" ? 0 : $(dest).offset().top;
		css.left = $(dest).css("position") === "relative" ? 0 : $(dest).offset().left;
		css.width = $(dest).outerWidth();
		css.height = $(dest).outerHeight();
	}
	if (!windowOrDocument) {
		css.WebkitBorderTopLeftRadius = $(dest).css("WebkitBorderTopLeftRadius");
		css.WebkitBorderTopRightRadius = $(dest).css("WebkitBorderTopRightRadius");
		css.WebkitBorderBottomLeftRadius = $(dest).css("WebkitBorderBottomLeftRadius");
		css.WebkitBorderBottomRightRadius = $(dest).css("WebkitBorderBottomRightRadius");
		css.KhtmlBorderTopLeftRadius = $(dest).css("KhtmlBorderTopLeftRadius");
		css.KhtmlBorderTopRightRadius = $(dest).css("KhtmlBorderTopRightRadius");
		css.KhtmlBorderBottomLeftRadius = $(dest).css("KhtmlBorderBottomLeftRadius");
		css.KhtmlBorderBottomRightRadius = $(dest).css("KhtmlBorderBottomRightRadius");
		css.borderTopLeftRadius = $(dest).css("borderTopLeftRadius");
		css.borderTopRightRadius = $(dest).css("borderTopRightRadius");
		css.borderBottomLeftRadius = $(dest).css("borderBottomLeftRadius");
		css.borderBottomRightRadius = $(dest).css("borderBottomRightRadius");
	}

	/*
	 * スタイル適用
	 */
	$(target).css(css);

	return true;
};
