/**
 * 標準Stringオブジェクト拡張クラス<br>
 * <br>
 * Javascript標準Stringオブジェクトの拡張クラスです。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var StringEx = function() {
};

/**
 * 指定されたオブジェクトを文字列型として返却します。<br>
 * @param {Object} object オブジェクト
 * @returns {String} オブジェクト文字列
 */
String.valueOf = function(object) {
	if (object) {
		return "" + object;
	} else {
		return "";
	}
};

/**
 * 指定されたオブジェクトが同値か判定します。<br>
 * @param {Object} object オブジェクト
 * @returns {Boolean} オブジェクトが同値の場合にtrueを返却
 */
String.prototype.equals = function(object) {
	if (!object) {
		return false;
	} else {
		return this.valueOf().toString() === object.valueOf().toString();
	}
};

/**
 * 指定されたオブジェクトが同値か判定します。<br>
 * @param {Object} object オブジェクト
 * @returns {Boolean} オブジェクトが同値の場合にtrueを返却
 */
String.prototype.equalsIgnoreCase = function(object) {
	if (!object) {
		return false;
	} else {
		return this.valueOf().toString().toLowerCase() === object.valueOf().toString().toLowerCase();
	}
};

/**
 * 自身の文字列をトリム(前後)して提供します。<br>
 * @returns {String} 文字列
 */
String.prototype.trim = function() {
	return this.replace(new RegExp("^\s+|\s+$"), "");
};

/**
 * 指定された文字列で始まる文字列であるか判定します。<br>
 * @param {String} value 判定対象文字列
 * @returns {Boolean} 指定された文字列で始まる文字列である場合にtrueを返却
 */
String.prototype.startsWith = function(value) {
	return this.indexOf(value) === 0;
};

/**
 * 指定された文字列で終わる文字列であるか判定します。<br>
 * @param {String} value 判定対象文字列
 * @returns {Boolean} 指定された文字列で終わる文字列である場合にtrueを返却
 */
String.prototype.endsWith = function(value) {
	var offset = this.length - value.length;
	return offset >= 0 && this.lastIndexOf(value) === offset;
};

/**
 * 文字列内に指定文字列が含まれるか判定します。<br>
 * @param {String} string 判定文字列
 * @returns {Boolean} 文字列内に指定文字列が含まれる場合にtrueを返却
 */
String.prototype.contains = function(string) {
	if (this === "" || string === undefined || string === null || string === "") {
		return false;
	}
	return this.indexOf(string) >= 0;
};
