/**
 * ダイアログ操作クラス<br>
 * <br>
 * jQuery UIが提供するダイアログアダプタクラスです。<br>
 * 汎用的なダイアログ操作インタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var Dialog = function() {
};

/**
 * アラートダイアログを表示します。<br>
 * @param {String} message アラートメッセージ
 * @param {Object} defer ウィンドウクローズ時実行Deferredオブジェクト
 * @returns {Object} 直列処理用Deferredオブジェクト
 */
Dialog.alert = function(message, defer) {
	if (!defer || defer == null) {
		defer = $.Deferred();
	}

	// エラーオブジェクトスタックトレース取得
	var stacks = message && message.stack ? message.stack : null;

	// Errorオブジェクト時(InternetExplorer)
	if (message instanceof Error) {
		message = message.message;
	}

	// メッセージデコード処理
	message = "" + message;
	message = message.replace(/\n|\r/g, "<br>");

	// ダイアログユニークID生成(複数ダイアログ表示対応)
	var idPrefix = "alertDialog";
	var uniqueId = "";
	while (uniqueId === "" || $("#" + idPrefix + uniqueId)[0]) {
		uniqueId = new Date().getTime();
	}

	// ダイアログソース生成
	var dialogHTML = "";
	dialogHTML += "<div id=\"" + idPrefix + uniqueId + "\" title=\"" + STR_ALERT_DIALOG_TITLE + "\">";
	dialogHTML += "<p>";
	dialogHTML += "<span class=\"ui-icon ui-icon-alert\" style=\"float:left; margin:0 7px 50px 0;\"></span>";
	dialogHTML += message;
	dialogHTML += "</p>";
	if (FLG_JSSTACKTRACE_ENABLED && stacks) {
		// エラースタック表示を行う場合はコンテンツパスを除去してトレース文字列を作成
		var stacksArray = stacks.split("\n");
		var stacks = "";
		for ( var i = 0; i <= stacksArray.length - 1; i++) {
			stacks += stacksArray[i].replace(/( +at )(.*)(http.*\/)(.*)/g, "$1$2$4") + "\n";
		}
		dialogHTML += "<pre style=\"clear: both; padding: .4em; overflow: scroll; background-color: #ffeeee; color: #ff2222; border: 1px solid #ddaaaa;\">";
		dialogHTML += stacks;
		dialogHTML += "</pre>";
	}
	dialogHTML += "</div>";

	$("body").append(dialogHTML);

	// ダイアログ生成
	$("#" + idPrefix + uniqueId).dialog({
		resizable : true,
		modal : true,
		position : "center",
		minWidth : 600,
		minHeight : 180,
		buttons : {
			"OK" : function() {
				$(this).dialog("close");
				$(this).remove();
			}
		},
		close : function() {
			defer.resolve();
		}
	});

	return defer.promise();
};
