/**
 * ページコンテンツ操作クラス<br>
 * <br>
 * ブラウザページコンテンツに対する各種操作インタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 *-->
 */

/**
 * コンストラクタ<br>
 */
var Content = function() {
};

/**
 * 指定されたタグの最大のzIndex値を取得します。<br>
 * @param {String} tagName 対象タグ名
 * @returns {Number} 最大のzIndex値
 */
Content.getMaxZIndexByTagname = function(tagName) {
	var zIndex = 0;
	$(tagName).each(function() {
		//		var elementZIndex = $(this).css("z-index");
		//		if (!elementZIndex || elementZIndex === "auto") {
		//			elementZIndex = 0;
		//		}
		//		if (zIndex < elementZIndex) {
		//			zIndex = elementZIndex;
		//		}
		var element = $(this)[0];
		var elementZIndex = element.style.zIndex;
		if (!elementZIndex) {
			var css = element.currentStyle || document.defaultView.getComputedStyle(element, null);
			elementZIndex = css ? css.zIndex : 0;
		}
		elementZIndex -= 0;
		if (zIndex < elementZIndex) {
			zIndex = elementZIndex;
		}
	});
	return zIndex;
};

/**
 * ページコンテンツ内で最大のzIndex値を取得します。<br>
 * @returns {Number} 最大のzIndex値
 */
Content.getMaxZIndex = function() {
	return this.getMaxZIndexByTagname("*");
};

/**
 * ページコンテンツ幅(ピクセル)を取得します。<br>
 * ドキュメントコンテンツを超えるウィンドウサイズとなっている場合はそのサイズとなります。<br>
 * @returns {Number} ページコンテンツ幅(ピクセル)
 */
Content.getContentWidth = function() {
	var scrollWidth = 0;
	var offsetWidth = 0;
	if ($.browser.msie) {
		scrollWidth = Math.max(document.documentElement.scrollWidth, document.body.scrollWidth);
		offsetWidth = Math.max(document.documentElement.offsetWidth, document.body.offsetWidth);
		if (scrollWidth < offsetWidth) {
			return parseInt($(window).width());
		} else {
			return parseInt(scrollWidth);
		}
	} else {
		return parseInt($(document).width());
	}
};

/**
 * ページコンテンツ高さ(ピクセル)を取得します。<br>
 * ドキュメントコンテンツを超えるウィンドウサイズとなっている場合はそのサイズとなります。<br>
 * @returns {Number} ページコンテンツ高さ(ピクセル)
 */
Content.getContentHeight = function() {
	var scrollHeight = 0;
	var offsetHeight = 0;
	if ($.browser.msie && $.browser.version < 7) {
		scrollHeight = Math.max(document.documentElement.scrollHeight, document.body.scrollHeight);
		offsetHeight = Math.max(document.documentElement.offsetHeight, document.body.offsetHeight);
		if (scrollHeight < offsetHeight) {
			return parseInt($(window).height());
		} else {
			return parseInt(scrollHeight);
		}
	} else {
		return parseInt($(document).height());
	}
};

/**
 * 表示域幅(ピクセル)を取得します。<br>
 * ドキュメントコンテンツを下回るウィンドウサイズの場合、現在表示されているサイズとなります。<br>
 * @returns {Number} 表示域幅(ピクセル)
 */
Content.getViewportWidth = function() {
	if (jQuery.browser.msie) {
		return parseInt(document.documentElement.clientWidth);
	} else if (jQuery.browser.mozilla) {
		return parseInt(document.documentElement.clientWidth);
	} else if (jQuery.browser.webkit) {
		return parseInt(window.innerWidth);
	} else if (jQuery.browser.opera) {
		if (parseInt(jQuery.browser.version) <= 9) {
			return parseInt(document.body.clientWidth);
		} else {
			return parseInt(document.documentElement.clientWidth);
		}
	}
};

/**
 * 表示域高さ(ピクセル)を取得します。<br>
 * ドキュメントコンテンツを下回るウィンドウサイズの場合、現在表示されているサイズとなります。<br>
 * @returns {Number} 表示域高さ(ピクセル)
 */
Content.getViewportHeight = function() {
	if (jQuery.browser.msie) {
		return parseInt(document.documentElement.clientHeight);
	} else if (jQuery.browser.mozilla) {
		return parseInt(document.documentElement.clientHeight);
	} else if (jQuery.browser.webkit) {
		return parseInt(window.innerHeight);
	} else if (jQuery.browser.opera) {
		if (parseInt(jQuery.browser.version) <= 9) {
			return parseInt(document.body.clientHeight);
		} else {
			return parseInt(document.documentElement.clientHeight);
		}
	}
};
