/**
 * アプリケーションコントロールクラス<br>
 * <br>
 * 各機能が共通的な処理を行う場合はここで提供されるインタフェースを提供します。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者				更新内容
 * 2012/07/02	Kitagawa			新規作成
 * 2012/11/28	Kitagawa			JSONリクエスト時のフラグを送信するように修正
 *-->
 */
function _Control() {
};
_Control.prototype = {

	/** 定数(Cookie有効日数) */
	COOKIE_EXPIRES : 7,

	/** 定数(UIフォントサイズCookieキー) */
	COOKIE_KEY_UI_FONT_SIZE : "ui-font-size",

	/** 定数(UIテーマCookieキー) */
	COOKIE_KEY_UI_THEME : "ui-theme",

	/** 定数(セッションチェック間隔(ミリ秒)) */
	SESSION_CHECK_INTERVAL : 1000,

	/** 定数(ドキュメント初期化ウェイト(ミリ秒)) */
	DOCUMENT_REDY_DELAY : 1,

	/** 定数(ウィンドウスクロール横位置プロパティ) */
	NAME_WINDOW_SCROLL_X : "windowScrollX",

	/** 定数(ウィンドウスクロール縦位置プロパティ) */
	NAME_WINDOW_SCROLL_Y : "windowScrollY",

	/** 定数(ウィンドIDプロパティ) */
	NAME_WINDOW_ID : "windowId",

	/** 定数(ポップアップウィンドウフラグプロパティ) */
	NAME_POPUPWINDOW_FLAG : "popupWindow",

	/** 定数(ポップアップウィンドウアクションパスプロパティ) */
	NAME_POPUPWINDOW_ACTION_PATH : "actionPath",

	/** 定数(JSONリクエストフラグ) */
	NAME_JSON_REQUEST : "jsonreq",

	/** 定数(Strutsトークン) */
	NAME_STRUTS_TOKEN : "org.apache.struts.taglib.html.TOKEN",

	/** 定数(拡張トークン) */
	NAME_EXT_TOKEN : "token",

	/** 定数(サブミットフォームID) */
	ID_SUBMIT_FORM : "mainSubmitForm",

	/** 定数(ウィンドウIDフィールドID) */
	ID_WINDOW_ID : "windowId",

	/** 定数(StrutsトークンフィールドID) */
	ID_STRUTS_TOKEN : "strutsToken",

	/** 定数(拡張トークンフィールドID) */
	ID_EXT_TOKEN : "extToken",

	/** 定数(フィールド編集済みフラグID) */
	ID_FIELD_EDITED : "fieldEdited",

	/** 定数(フォーカスフィールドID) */
	ID_FOCUS_ID : "focusedId",

	/** 定数(サブミットフォームID) */
	ID_SUBMIT_FORM : "mainSubmitForm",

	/** 定数(ポップアップウィンドウ内部ドキュメントID) */
	ID_POPUPWINDOW_DOCUMENT : "modalDocument",

	/** 定数(ページロックレイヤID) */
	ID_CONTENT_LOCK_LAYER : "pageLockLayer",

	/** 定数(ページコンテンツID) */
	ID_PAGE_CONTENT : "pageContent",

	/** 定数(ページヘッダID) */
	ID_PAGE_HEADER : "pageHeader",

	/** 定数(ページフッタID) */
	ID_PAGE_FOOTER : "pageFooter",

	/** 定数(ページメッセージ枠ID) */
	ID_PAGE_MASSAGE_PANE : "messagePane",

	/** 定数(フォントローラーID) */
	ID_UI_FONT_ROLLER : "uiFontSizeRoller",

	/** 定数(UIテーマクラス名) */
	CLASS_UI_THEME : "ui-theme",

	/** 定数(ポップアップウィンドウJSP) */
	JSP_POPUPWINDOW : "/popup.jsp",

	/** 定数(ポップアップウィンドウオプション) */
	OPTION_POPUPWINDOW : "width=0, height=0, menubar=no, toolbar=no, scrollbars=no, location=no, status= no, resizable=yes",

	/** 定数(モーダルウィンドウオプション) */
	OPTION_MODALWINDOW : "dialogWidth:0px; dialogHeight:0px; scroll:no;",

	/** 定数(アクションパス:ログアウト) */
	ACTION_LOGOUT : "/G00001/logout",

	/** コンテキストパス */
	requestContextPath : "",

	/** サーブレットパス */
	requestServletPath : "",

	/** サブミット済みフラグ */
	submitted : false,

	/** 更新項目編集済みフラグ */
	edited : false,

//	/**
//	 * ページコンテンツをロックします。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	lockContent : function() {
//		$(window).bind("keydown." + this.ID_CONTENT_LOCK_LAYER, function() {
//			event.stopPropagation();
//			event.stopImmediatePropagation();
//			return false;
//		});
//		$("#" + this.ID_CONTENT_LOCK_LAYER).css("display", "block");
//		return true;
//	},
//
//	/**
//	 * ページコンテンツをアンロックします。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	unlockContent : function() {
//		$("#" + this.ID_CONTENT_LOCK_LAYER).css("display", "none");
//		$(window).unbind("keydown." + this.ID_CONTENT_LOCK_LAYER);
//		return true;
//	},
//
//	/**
//	 * 実際に利用可能なコンテンツ幅を取得します。<br>
//	 * ヘッダー、フッター、メッセージ部のサイズを考慮したコンテンツ域のサイズを取得します。<br>
//	 * @returns コンテンツ幅
//	 */
//	getContentWidth : function() {
//		return $("#" + this.ID_PAGE_CONTENT).innerWidth() - 22;
//	},
//
//	/**
//	 * 実際に利用可能なコンテンツ高さを取得します。<br>
//	 * ヘッダー、フッター、メッセージ部のサイズを考慮したコンテンツ域のサイズを取得します。<br>
//	 * @returns コンテンツ高さ
//	 */
//	getContentHeight : function() {
//		return $(window).innerHeight() - $("#" + this.ID_PAGE_HEADER).outerHeight() - $("#" + this.ID_PAGE_FOOTER).outerHeight() - $("#" + this.ID_PAGE_MASSAGE_PANE).outerHeight();
//	},
//
//	/**
//	 * ウィンドウサイズを設定します。<br>
//	 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
//	 * @param width ウィンドウ幅
//	 * @param height ウィンドウ高さ
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setWindowSize : function(width, height) {
//		if (window.dialogWidth) {
//			window.dialogWidth = width + "px";
//		}
//		if (window.dialogHeight) {
//			window.dialogHeight = height + "px";
//		}
//		if (!window.dialogWidth && !window.dialogHeight) {
//			window.resizeTo(width, height);
//		}
//		return true;
//	},
//
//	/**
//	 * ウィンドウ位置を設定します。<br>
//	 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
//	 * @param top ウィンドウ上部位置
//	 * @param left ウィンドウ左部位置
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setWindowLocation : function(top, left) {
//		if (window.dialogLeft) {
//			window.dialogLeft = left + "px";
//		}
//		if (window.dialogTop) {
//			window.dialogTop = top + "px";
//		}
//		if (!window.dialogLeft && !window.dialogTop) {
//			window.moveTo(left, top);
//		}
//		return true;
//	},
//
//	/**
//	 * ウィンドウ位置を中央に設定します。<br>
//	 * 通常ウィンドウ、ダイアログ表示を考慮した設定処理を実施します。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setWindowCenter : function() {
//		var width = $(window).width();
//		var height = $(window).height();
//		var left = (screen.width - width) / 2;
//		var top = (screen.height - height) / 2;
//		this.setWindowLocation(top, left);
//		return true;
//	},
//
//	/**
//	 * コンテキストパスを設定します。<br>
//	 * @param path コンテキストパス
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setRequestContextPath : function(path) {
//		this.requestContextPath = path;
//		return true;
//	},
//
//	/**
//	 * コンテキストパスを取得します。<br>
//	 * @returns コンテキストパス
//	 */
//	getRequestContextPath : function() {
//		return this.requestContextPath;
//	},
//
//	/**
//	 * サーブレットパスを設定します。<br>
//	 * @param path サーブレットパス
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setRequestServletPath : function(path) {
//		this.requestServletPath = path;
//		return true;
//	},
//
//	/**
//	 * サーブレットパスを設定します。<br>
//	 * @returns サーブレットパス
//	 */
//	getRequestServletPath : function() {
//		return this.requestServletPath;
//	},
//
//	/**
//	 * アクションパスを取得します。<br>
//	 * @param url リクエストURL
//	 * @returns アクションパス
//	 */
//	getActionPath : function(url) {
//		var actionPath = this.requestContextPath + this.requestServletPath + url;
//		return actionPath;
//	},
//
//	/**
//	 * ブラウザ情報文字列を取得します。<br>
//	 * @returns ブラウザ情報文字列
//	 */
//	getBrowser : function() {
//		var userAgent = window.navigator.userAgent.toLowerCase();
//		var appVersion = window.navigator.appVersion.toLowerCase();
//		if (userAgent.indexOf("msie") > -1) {
//			if (appVersion.indexOf("msie 6.0") > -1) {
//				return "IE6";
//			} else if (appVersion.indexOf("msie 7.0") > -1) {
//				return "IE7";
//			} else if (appVersion.indexOf("msie 8.0") > -1) {
//				return "IE8";
//			} else {
//				return "Unknown";
//			}
//		} else if (userAgent.indexOf("firefox") > -1) {
//			return "Firefox";
//		} else if (userAgent.indexOf("opera") > -1) {
//			return "Opera";
//		} else if (userAgent.indexOf("chrome") > -1) {
//			return "Chrome";
//		} else if (userAgent.indexOf("safari") > -1) {
//			return "Safari";
//		} else {
//			return "Unknown";
//		}
//	},
//
//	/**
//	 * InternetExploreのバージョンを取得します。<br>
//	 * @returns InternetExploreのバージョン
//	 */
//	getIEVersion : function() {
//		var undef = 0, v = 3, div = document.createElement('div');
//		while (div.innerHTML = '<!--[if gt IE ' + (++v) + ']><i></i><![endif]-->', div.getElementsByTagName('i')[0]);
//		return v > 4 ? v : undef;
//	},

	/**
	 * 指定された名称のjQuery UIテーマに変更します。<br>
	 * @param name テーマ名
	 * @return 有効にしたテーマ名
	 */
	changeUITheme : function(name) {
		var selected = "";
		if (name && name !== "undefined" && name !== "") {
			var exist = false;
			$("link." + this.CLASS_UI_THEME).attr("disabled", "disabled");
			$("link." + this.CLASS_UI_THEME).each(function() {
				if ($(this).attr("title") === name) {
					$(this).removeAttr("disabled");
					exist = true;
					selected = $(this).attr("title");
				}
			});
			if (!exist) {
				changeUITheme();
			} else {
				$.cookie(this.COOKIE_KEY_UI_THEME, name, {
					path : this.requestContextPath + "/",
					expires : this.COOKIE_EXPIRES
				});
			}
		} else {
			$("link." + this.CLASS_UI_THEME + ":first").removeAttr("disabled");
			selected = $("link." + this.CLASS_UI_THEME + ":first").attr("title");
			$.cookie(this.COOKIE_KEY_UI_THEME, $("link." + this.CLASS_UI_THEME + ":first").attr("title"), {
				path : this.requestContextPath + "/",
				expires : this.COOKIE_EXPIRES
			});
		}
		return selected;
	},

	/**
	 * 指定されたフォントサイズに変更します。<br>
	 * @param size フォントサイズ
	 * @return 変更したフォントサイズ
	 */
	changeUIFontSize : function(size) {
		if (!size || size === "undefined" || name === "") {
			size = $("#" + this.ID_UI_FONT_ROLLER + " option:first").val();
		}
		$.cookie(this.COOKIE_KEY_UI_FONT_SIZE, size, {
			path : this.requestContextPath + "/",
			expires : this.COOKIE_EXPIRES
		});
		$("body").css("font-size", size);

		// 金額フィールドスタイル変更
		$("link.ui-offont").attr("disabled", "disabled");
		$("link.ui-offont").each(function() {
			if ($(this).attr("title") === size) {
				$(this).removeAttr("disabled");
			} else {
			}
		});

		return size;
	},

//	/**
//	 * イベントオブジェクトからキーコードを取得します。<br>
//	 * @param e イベントオブジェクト
//	 * @returns キーコード
//	 */
//	getKeyCode : function(e) {
//		if (document.all) {
//			return e.keyCode;
//		} else if (document.getElementById) {
//			return (e.keyCode) ? e.keyCode : e.charCode;
//		} else if (document.layers) {
//			return e.which;
//		} else {
//			return e.keyCode;
//		}
//	},

	/**
	 * フォーカス位置退避値に設定されている要素にフォーカスを戻します。<br>
	 * @returns 正常終了した場合はtrueを返却
	 */
	restoreFocusedElement : function() {
		try {
			if ($("#" + this.ID_FOCUS_ID) && $("#" + this.ID_FOCUS_ID).val() !== "") {
				var target = $("#" + this.ID_FOCUS_ID).val();
				target = target.split("[").join("\\[");
				target = target.split("]").join("\\]");

				if ($("#" + target).get(0)) {
					$("#" + target).focus();
				} else {
					if ($("[name=" + target + "]").get(0)) {
						$("[name=" + target + "]").focus();
					} else {
						$("#" + this.ID_FOCUS_ID).val(undefined);
						ElementUtil.initFocus($("#" + this.ID_PAGE_CONTENT));
					}
				}
			} else {
				ElementUtil.initFocus($("#" + this.ID_PAGE_CONTENT));
			}
			return true;
		} catch (e) {
			return false;
		}
	},

	/**
	 * フォーカス位置を退避します。<br>
	 * @param jElement 対象jQuery要素
	 * @returns 正常終了した場合はtrueを返却
	 */
	backupFocusedElement : function(jElement) {
		try {
			if (jElement) {
				if (jElement.attr("id")) {
					$("#" + this.ID_FOCUS_ID).val(jElement.attr("id"));
				} else if (jElement.attr("name")) {
					$("#" + this.ID_FOCUS_ID).val(jElement.attr("name"));
				} else {
					$("#" + this.ID_FOCUS_ID).val(undefined);
				}
			}
			return true;
		} catch (e) {
			return false;
		}
	},

	/**
	 * フォーカス位置退避情報をクリアします。<br>
	 * @returns 正常終了した場合はtrueを返却
	 */
	clearFocusedElement : function() {
		try {
			$("#" + this.ID_FOCUS_ID).val(undefined);
			return true;
		} catch (e) {
			return false;
		}
	},

//	/**
//	 * 指定されたURLに通常遷移方式でのサブミットを行います。<br>
//	 * 更新項目の編集済みフラグが設定されている場合で編集状況チェックフラグが
//	 * 指定されている場合は処理続行確認ダイアログを表示します。<br>
//	 * @param url サブミットURL
//	 * @param editedCheck 更新項目の編集済みチェックを行う場合はtrueを指定
//	 * @returns サブミットを実行した場合はtrueを返却
//	 */
//	doSubmit : function(url, editedCheck) {
//		// サブミット中チェック
//		if (this.submitted) {
//			alert(Control.getMessage("FWER00064"));
//			return false;
//		}
//
//		// 引数妥当性チェック
//		if (editedCheck === undefined) {
//			alert(Control.getMessage("FWER00063", [DateUtil.getLocalYYYYsMMsDDaHHcSS()]));
//			return false;
//		}
//
//		// 編集済み項目存在フラグが設定されている場合は確認ダイアログを表示
//		if (editedCheck && this.isEdited()) {
//			if (!window.confirm(this.getMessage("FWWN00010"))) {
//				return false;
//			}
//		}
//
//		// ダブルサブミット制御フラグ設定
//		this.submitted = true;
//		this.lockContent();
//
//		// 非活性項目の活性化(非活性フィールド強制サブミット対応)
//		//var disabled = $(":disabled").removeAttr("disabled");
//		var disabled = $("input:disabled, textarea:disabled, select:disabled").removeAttr("disabled");
//
//		var actionPath = this.getActionPath(url);
//		$("[name=" + this.NAME_WINDOW_SCROLL_X + "]").val($(window).scrollLeft());
//		$("[name=" + this.NAME_WINDOW_SCROLL_Y + "]").val($(window).scrollTop());
//		$("#" + this.ID_SUBMIT_FORM).attr("action", actionPath);
//		$("#" + this.ID_SUBMIT_FORM).submit();
//
//		// 活性化した非活性フィールドを元に戻す
//		disabled.attr("disabled", "disabled");
//
//		return true;
//	},

	/**
	 * 指定されたURLにダウンロードリクエストを行います。<br>
	 * @param url サブミットURL
	 * @returns サブミットを実行した場合はtrueを返却
	 */
	doDownload : function(url) {
		// サブミット中チェック
		if (this.submitted) {
			alert(Control.getMessage("FWER00064"));
			return false;
		}

		// 非活性項目の活性化(非活性フィールド強制サブミット対応)
		//var disabled = $(":disabled").removeAttr("disabled");
		var disabled = $("input:disabled, textarea:disabled, select:disabled").removeAttr("disabled");

		var actionPath = this.getActionPath(url);
		$("[name=" + this.NAME_WINDOW_SCROLL_X + "]").val($(window).scrollLeft());
		$("[name=" + this.NAME_WINDOW_SCROLL_Y + "]").val($(window).scrollTop());
		$("#" + this.ID_SUBMIT_FORM).attr("action", actionPath);
		$("#" + this.ID_SUBMIT_FORM).submit();

		// 活性化した非活性フィールドを元に戻す
		disabled.attr("disabled", "disabled");

		return true;
	},

	/**
	 * 指定されたURLにサブミットを行い、ポップアップウィンドウを表示します。<br>
	 * クローズ時の処理が指定されている場合はウィンドウクローズのタイミングで、
	 * その処理が呼び出されます(疑似的なモーダルウィンドウ処理の再現)。<br>
	 * また、ポップアップ元コンテンツをロックするフラグが設定されている場合、
	 * コンテンツの操作をロックする処理が併せて実施されます。<br>
	 * @param url サブミットURL
	 * @param name ウィンドウ名(未指定時はミリ秒でユニーク値)
	 * @param closeFunction ポップアップウィンドウクローズ時処理Functionオブジェクト
	 * @param contentLock 親画面コンテンツロックを行う場合はtrueを指定
	 * @returns 正常終了した場合はtrueを返却
	 */
	doPopupWindow : function(url, name, closeFunction, contentLock) {
		// サブミット中チェック
		if (this.submitted) {
			alert(Control.getMessage("FWER00064"));
			return false;
		}

		// 自ウィンドウトークン取得
		var token = "";
		if ($("#" + this.ID_STRUTS_TOKEN) && $("#" + this.ID_STRUTS_TOKEN).val() !== "undefined") {
			token = $("#" + this.ID_STRUTS_TOKEN).val();
		}
		if (!token || token === "") {
			if ($("#" + this.ID_EXT_TOKEN) && $("#" + this.ID_EXT_TOKEN).val() !== "undefined") {
				token = $("#" + this.ID_EXT_TOKEN).val();
			}
		}

		// キャッシュ無効化ユニークキー生成
		var uniqueKey = new Date().getTime();

		// ウィンドウID取得
		var windowId = $("#" + this.ID_WINDOW_ID).val();

		// アクションパス生成
		var actionPath = this.getActionPath(url);
		if (actionPath.indexOf("?") >= 0) {
			actionPath += "&";
			actionPath += this.NAME_WINDOW_ID + "=";
			actionPath += windowId;
			actionPath += "&";
			actionPath += this.NAME_POPUPWINDOW_FLAG + "=";
			actionPath += "1";
			actionPath += "&";
			actionPath += this.NAME_STRUTS_TOKEN + "=";
			actionPath += token;
			actionPath += "&";
			actionPath += this.NAME_EXT_TOKEN + "=";
			actionPath += token;
		} else {
			actionPath += "?";
			actionPath += this.NAME_WINDOW_ID + "=";
			actionPath += windowId;
			actionPath += "&";
			actionPath += this.NAME_POPUPWINDOW_FLAG + "=";
			actionPath += +"1";
			actionPath += "&";
			actionPath += this.NAME_STRUTS_TOKEN + "=";
			actionPath += token;
			actionPath += "&";
			actionPath += this.NAME_EXT_TOKEN + "=";
			actionPath += token;
		}

		// コンテンツロック
		if (contentLock) {
			this.lockContent();
		}

		// URL構築
		var url = this.requestContextPath + this.JSP_POPUPWINDOW;
		url += "?";
		url += "_u=";
		url += uniqueKey;
		url += "&";
		url += this.NAME_POPUPWINDOW_ACTION_PATH;
		url += "=";
		url += escape(actionPath);
		url += "&";
		url += this.NAME_POPUPWINDOW_FLAG;
		url += "=";
		url += "1";
		url += this.NAME_STRUTS_TOKEN + "=";
		url += token;
		url += "&";
		url += this.NAME_EXT_TOKEN + "=";
		url += token;

		// ポップアップウィンドウ表示
		var w = null;
		if (this.getBrowser() === "Chrome") {
			/*
			 * Google Chrome
			 * (IFrameを利用した親画面との値連携、ウィンドウサイズ設定が行えない為、ポップアップ自体のパスをリダイレクト)
			 */
			if (name !== null && name !== "") {
				//w = window.open(actionPath, name, OPTION_POPUPWINDOW);
				w = window.open(url, name, this.OPTION_POPUPWINDOW);
			} else {
				//w = window.open(actionPath, new Date().getTime(), OPTION_POPUPWINDOW);
				w = window.open(url, new Date().getTime(), this.OPTION_POPUPWINDOW);
			}
		} else {
			/*
			 * Google Chrome以外
			 * (IFrameを利用した親画面との値連携、ウィンドウサイズ設定が行えるブラウザ)
			 */
			//if (name !== null && name !== "") {
			//	w = window.open(this.requestContextPath + this.JSP_POPUPWINDOW + "?_u=" + uniqueKey, name, this.OPTION_POPUPWINDOW);
			//} else {
			//	w = window.open(this.requestContextPath + this.JSP_POPUPWINDOW + "?_u=" + uniqueKey, new Date().getTime(), this.OPTION_POPUPWINDOW);
			//}
			if (name !== null && name !== "") {
				//w = window.open(actionPath, name, OPTION_POPUPWINDOW);
				w = window.open(url, name, this.OPTION_POPUPWINDOW);
			} else {
				//w = window.open(actionPath, new Date().getTime(), OPTION_POPUPWINDOW);
				w = window.open(url, new Date().getTime(), this.OPTION_POPUPWINDOW);
			}
		}

		//if (this.getBrowser() !== "Chrome") {
		//	/*
		//	 * Google Chrome以外
		//	 * (ドキュメントがロードされたタイミングでIFrameソースを設定する)
		//	 */
		//	var windowOpenTimerId = null;
		//	windowOpenTimerId = setInterval(function() {
		//		if (w) {
		//			if (w.document) {
		//				if (w.document.getElementById(this.ID_POPUPWINDOW_DOCUMENT)) {
		//					w.document.getElementById(this.ID_POPUPWINDOW_DOCUMENT).src = actionPath;
		//					// タイマークリア
		//					clearInterval(windowOpenTimerId);
		//				}
		//			}
		//		}
		//		return true;
		//	}, 1);
		//}

		/*
		 * 疑似的なウィンドウ表示時のコールバック処理
		 * (モーダルウィンドウコールバックと同様の処理を実現する)
		 */
		var callBackTimerId = null;
		callBackTimerId = setInterval(function() {
			if (w && w.closed) {
				// 疑似戻り値データ生成
				var virtualReturnValue = new Object();
				if (w.returnValue) {
					for ( var key in w.returnValue) {
						virtualReturnValue[key] = w.returnValue[key];
					}
				}

				// 自ウィンドウトークン更新
				if ($("#" + this.ID_STRUTS_TOKEN) && virtualReturnValue && virtualReturnValue[this.ID_STRUTS_TOKEN] !== "undefined") {
					$("#" + this.ID_STRUTS_TOKEN).val(virtualReturnValue[this.ID_STRUTS_TOKEN]);
				}
				if ($("#" + this.ID_EXT_TOKEN) && virtualReturnValue && virtualReturnValue[this.ID_EXT_TOKEN] !== "undefined") {
					$("#" + this.ID_EXT_TOKEN).val(virtualReturnValue[this.ID_EXT_TOKEN]);
				}

				// トークン情報を戻り値データから削除
				if (virtualReturnValue) {
					delete virtualReturnValue[Control.ID_STRUTS_TOKEN];
					delete virtualReturnValue[Control.ID_EXT_TOKEN];
					var count = 0;
					for ( var key in virtualReturnValue) {
						count++;
					}
					if (count == 0) {
						virtualReturnValue = undefined;
					}
				}

				// ポップアップクローズ時処理
				if (closeFunction) {
					closeFunction(virtualReturnValue);
				}

				// タイマークリア
				clearInterval(callBackTimerId);

				// コンテンツアンロック
				if (contentLock) {
					Control.unlockContent();
				}
			}
			return true;
		}, 1);

		return true;
	},

	/**
	 * 指定されたURLにサブミットを行い、モーダルウィンドウを表示します。<br>
	 * クローズ時の処理が指定されている場合はウィンドウクローズのタイミングで、
	 * その処理が呼び出されます。<br>
	 * @param url サブミットURL
	 * @param closeFunction モーダルダイアログクローズ時処理Functionオブジェクト
	 * @returns 正常終了した場合はtrueを返却
	 */
	doModalWindow : function(url, closeFunction) {
		// サブミット中チェック
		if (this.submitted) {
			alert(Control.getMessage("FWER00064"));
			return false;
		}

		var uniqueKey = new Date().getTime();
		if (this.getBrowser() === "Chrome") {
			// Google Chromeの場合はshowModalDialogが正規対応していないためポップアップとする
			this.doPopupWindow(url, null, closeFunction, true);
		} else {
			// 自ウィンドウトークン取得
			var token = "";
			if ($("#" + this.ID_STRUTS_TOKEN) && $("#" + this.ID_STRUTS_TOKEN).val() !== "undefined") {
				token = $("#" + this.ID_STRUTS_TOKEN).val();
			}
			if (!token || token === "") {
				if ($("#" + this.ID_EXT_TOKEN) && $("#" + this.ID_EXT_TOKEN).val() !== "undefined") {
					token = $("#" + this.ID_EXT_TOKEN).val();
				}
			}

			// ウィンドウID取得
			var windowId = $("#" + this.ID_WINDOW_ID).val();

			// アクションパス生成
			var actionPath = this.getActionPath(url);
			if (actionPath.indexOf("?") >= 0) {
				actionPath += "&";
				actionPath += this.NAME_WINDOW_ID + "=";
				actionPath += windowId;
				actionPath += "&";
				actionPath += this.NAME_POPUPWINDOW_FLAG + "=";
				actionPath += "1";
				actionPath += "&";
				actionPath += this.NAME_STRUTS_TOKEN + "=";
				actionPath += token;
				actionPath += "&";
				actionPath += this.NAME_EXT_TOKEN + "=";
				actionPath += token;
			} else {
				actionPath += "?";
				actionPath += this.NAME_WINDOW_ID + "=";
				actionPath += windowId;
				actionPath += "&";
				actionPath += this.NAME_POPUPWINDOW_FLAG + "=";
				actionPath += +"1";
				actionPath += "&";
				actionPath += this.NAME_STRUTS_TOKEN + "=";
				actionPath += token;
				actionPath += "&";
				actionPath += this.NAME_EXT_TOKEN + "=";
				actionPath += token;
			}

			var parameter = {
				url : actionPath,
				parentWindow : window
			};

			// コンテンツロック
			this.lockContent();

			// URL構築
			var url = this.requestContextPath + this.JSP_POPUPWINDOW;
			url += "?";
			url += "_u=";
			url += uniqueKey;
			url += "&";
			url += this.NAME_STRUTS_TOKEN + "=";
			url += token;
			url += "&";
			url += this.NAME_EXT_TOKEN + "=";
			url += token;

			// モーダルダイアログ表示
			returnParams = showModalDialog(url, parameter, this.OPTION_MODALWINDOW);

			// 自ウィンドウトークン更新
			if ($("#" + this.ID_STRUTS_TOKEN) && returnParams && returnParams[this.ID_STRUTS_TOKEN] !== "undefined") {
				$("#" + this.ID_STRUTS_TOKEN).val(returnParams[this.ID_STRUTS_TOKEN]);
			}
			if ($("#" + this.ID_EXT_TOKEN) && returnParams && returnParams[this.ID_EXT_TOKEN] !== "undefined") {
				$("#" + this.ID_EXT_TOKEN).val(returnParams[this.ID_EXT_TOKEN]);
			}

			// トークン情報を戻り値データから削除
			if (returnParams) {
				delete returnParams[this.ID_STRUTS_TOKEN];
				delete returnParams[this.ID_EXT_TOKEN];
				var count = 0;
				for ( var key in returnParams) {
					count++;
				}
				if (count == 0) {
					returnParams = undefined;
				}
			}

			// モーダルダイアログクローズ時処理
			if (closeFunction) {
				closeFunction(returnParams);
			}

			// コンテンツアンロック
			this.unlockContent();
		}
		return true;
	},

	/**
	 * 非同期JSON処理を行います。<br>
	 * @param url サブミットURL
	 * @param beforeFunction サーバ処理前処理Functionオブジェクト
	 * @param submitFunction サーバ処理成功時処理Functionオブジェクト
	 * @param completeFunction サーバ処理終了後処理Functionオブジェクト
	 * @param ignoreSubmittedCheck サブミットチェックを無視する場合にtrueを指定
	 * @returns 正常終了した場合はtrueを返却
	 */
	doAsyncJSON : function(url, beforeFunction, successFunction, completeFunction, ignoreSubmittedCheck) {
		// サブミット中チェック
		if (!ignoreSubmittedCheck && this.submitted) {
			alert(Control.getMessage("FWER00064"));
			window.event.srcElement.focus();
			ElementUtil.clearValues($(window.event.srcElement), false);
			return false;
		}

		/*
		 * サブミットフォーム内容のシリアライズ
		 */
		// 非活性項目の活性化(非活性フィールド強制サブミット対応)
		//var disabled = $(":disabled").removeAttr("disabled");
		var disabled = $("input:disabled, textarea:disabled, select:disabled").removeAttr("disabled");

		// フォーム情報のシリアライズ
		var data = $("#" + this.ID_SUBMIT_FORM).serialize();

		// 活性化した非活性フィールドを元に戻す
		disabled.attr("disabled", "disabled");

		// 配列プロパティは除去
		data = data.replace(/%5B/g, "[");
		data = data.replace(/%5D/g, "]");
		//console.log(data);
		//data = data.replace(/%5B[0-9]+%5D/g, "");
		//console.log(data);
		//alert(data);
		if (data !== "") {
			data += ("&" + this.NAME_JSON_REQUEST + "=1");
		}
		$.ajax({
			type : "post",
			url : this.getActionPath(url),
			async : true,
			cache : false,
			dataType : "json",
			data : data,
			beforeSend : function(XMLHttpRequest) {
				Control.submitted = true;
				if (beforeFunction !== null && beforeFunction) {
					beforeFunction();
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				// サーバーエラー時発生時
				alert(Control.getMessage("FWER00040", [DateUtil.getLocalYYYYsMMsDDaHHcSS()]));
				if (textStatus === "parsererror") {
					alert(Control.getMessage("FWER00071", [errorThrown]));
				}
				Control.submitted = false;
				Control.doSubmit(Control.ACTION_LOGOUT, false);
				return false;
			},
			success : function(data, dataType) {
				var errorMsg = "";
				for ( var i = 0; i <= data.errorActionMessages.length - 1; i++) {
					errorMsg += data.errorActionMessages[i];
					errorMsg += "\n";
				}
				var warningMsg = "";
				for ( var i = 0; i <= data.warningActionMessages.length - 1; i++) {
					warningMsg += data.warningActionMessages[i];
					warningMsg += "\n";
				}
				var informationMsg = "";
				for ( var i = 0; i <= data.informationActionMessages.length - 1; i++) {
					informationMsg += data.informationActionMessages[i];
					informationMsg += "\n";
				}
				if (errorMsg != "") {
					alert(errorMsg);
				}
				if (warningMsg != "") {
					alert(warningMsg);
				}
				if (informationMsg != "") {
					alert(informationMsg);
				}
				if (successFunction !== null && successFunction) {
					successFunction(data.result, dataType);
				}
				return true;
			},
			complete : function(XMLHttpRequest, textStatus) {
				if (completeFunction !== null && completeFunction) {
					completeFunction();
				}
				Control.submitted = false;
				return true;
			}
		});

		return true;
	},

//	/**
//	 * 指定されたサーバサイド側メッセージコードを基にメッセージを取得します。<br>
//	 * @param messageId メッセージコード
//	 * @param binds バインド文字列(配列定義)
//	 * @returns メッセージ文字列
//	 */
//	getMessage : function(messageId, binds) {
//		var render = "";
//		try {
//			render = eval("MSG_" + messageId);
//		} catch (e) {
//			render = "メッセージ取得エラー(" + messageId + ")";
//		}
//
//		if (!binds || binds === null || binds.length === 0) {
//			return render;
//		}
//		for ( var i = 0; i <= binds.length - 1; i++) {
//			//render = render.replace("{" + i + "}", binds[i]);
//			render = render.split("{" + i + "}").join(binds[i]);
//		}
//		return render;
//	},

//	/**
//	 * ポップアップ表示された自身のウィンドウを閉じます。<br>
//	 * 通常のwindow.close()は利用せずに以下を利用する。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	closeWindow : function() {
//		if (!window.returnValue) {
//			window.returnValue = {};
//		}
//		if ($("#" + this.ID_STRUTS_TOKEN) && $("#" + this.ID_STRUTS_TOKEN).val() !== "undefined") {
//			window.returnValue[this.ID_STRUTS_TOKEN] = $("#" + this.ID_STRUTS_TOKEN).val();
//		}
//		if ($("#" + this.ID_EXT_TOKEN) && $("#" + this.ID_EXT_TOKEN).val() !== "undefined") {
//			window.returnValue[this.ID_EXT_TOKEN] = $("#" + this.ID_EXT_TOKEN).val();
//		}
//		(window.open("", "_top").opener = top).close();
//		return true;
//	},
//
//	/**
//	 * 更新項目の編集済みフラグを設定します。<br>
//	 * フラグが設定された場合、サブミット時の編集項目チェックが行われます。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	setEdited : function() {
//		this.edited = true;
//		$("#" + this.ID_FIELD_EDITED).val("edited");
//		return true;
//	},
//
//	/**
//	 * 更新項目が編集済みか判断します。<br>
//	 * @returns 更新項目が編集済みの場合にtrueを返却
//	 */
//	isEdited : function() {
//		return this.edited || $("#" + this.ID_FIELD_EDITED).val() !== "";
//	},
//
//	/**
//	 * 更新項目の編集済みフラグをクリアします。<br>
//	 * @returns 正常終了した場合はtrueを返却
//	 */
//	clearEdited : function() {
//		this.edited = false;
//		$("#" + this.ID_FIELD_EDITED).val("");
//		return true;
//	},

	/**
	 * スクロールが存在する一覧の横スクロール時のヘッダスクロール連動を提供します。<br>
	 * @param scrollPane 一覧スクロール部div要素セレクタ
	 * @param headerPane ヘッダ部div要素セレクタ
	 * @returns 正常終了した場合はtrueを返却
	 */
	setSyncTableHeaderScroll : function(scrollPane, headerPane) {
		var SCROLL_EVENT_NAME = "scroll.syncTableHeader";
		var RESIZE_EVENT_NAME = "resize.syncTableHeader";
		$(scrollPane).unbind(SCROLL_EVENT_NAME);
		$(scrollPane).bind(SCROLL_EVENT_NAME, function() {
			$(headerPane).scrollLeft($(this).scrollLeft());
			if ($(headerPane).scrollLeft() < $(this).scrollLeft()) {
				//$(this).scrollLeft($(headerPane).scrollLeft());
				$(headerPane).css("position", "relative");
				$(headerPane).css("left", ($(headerPane).scrollLeft() - $(this).scrollLeft()) + "px");
			} else {
				$(headerPane).css("position", "static");
				$(headerPane).css("left", "0px");
			}
		});
		$(window).bind(RESIZE_EVENT_NAME, function() {
			$(headerPane).width($(scrollPane).width());
		});
		$(window).resize();
		return true;
	},

	/**
	 * 画面サイズを基準にしたスクロールレイアウトの自動サイズ補正を設定します。<br>
	 * @param innerElement 内部要素セレクタ
	 * @param scrollPane スクロールdiv要素セレクタ
	 * @param minWidthEm 最小幅em値(指定不要の場合はnull)
	 * @param minHeightEm 最小高さem値(指定不要の場合はnull)
	 * @param offsetWidthEm 画面幅からのオフセットem値
	 * @param offsetHeightEm 画面高さからのオフセットem値
	 * @param fixWidthEm 幅を固定サイズを指定する場合に指定する(上述のオフセット値は無視されます)
	 * @param fixHeightEm 高さを固定サイズを指定する場合に指定する(上述のオフセット値は無視されます)
	 * @returns 正常終了した場合はtrueを返却
	 */
	setAutoResizeScrollLayout : function(innerElement, scrollPane, minWidthEm, minHeightEm, offsetWidthEm, offsetHeightEm, fixWidthEm, fixHeightEm) {
		if (minWidthEm) {
			$(innerElement).css("min-width", minWidthEm + "em");
		}
		if (fixWidthEm) {
			$(scrollPane).width(ElementUtil.emToPx(fixWidthEm));
			$(innerElement).width(ElementUtil.emToPx(fixWidthEm) - ElementUtil.emToPx(1.5));
		} else {
			if (offsetWidthEm) {
				$(scrollPane).width(Control.getContentWidth() - ElementUtil.emToPx(offsetWidthEm));
				$(innerElement).width(Control.getContentWidth() - ElementUtil.emToPx(offsetWidthEm) - ElementUtil.emToPx(1.5));
			} else {
				$(scrollPane).width(Control.getContentWidth());
				$(innerElement).width(Control.getContentWidth() - ElementUtil.emToPx(1.5));
			}
		}
		$(window).bind("resize.autoResizeScrollLayout.width" + innerElement, function() {
			if (fixWidthEm) {
				$(scrollPane).width(ElementUtil.emToPx(fixWidthEm));
				$(innerElement).width(ElementUtil.emToPx(fixWidthEm) - ElementUtil.emToPx(1.5));
			} else {
				if (offsetWidthEm) {
					$(scrollPane).width(Control.getContentWidth() - ElementUtil.emToPx(offsetWidthEm));
					$(innerElement).width(Control.getContentWidth() - ElementUtil.emToPx(offsetWidthEm) - ElementUtil.emToPx(1.5));
				} else {
					$(scrollPane).width(Control.getContentWidth());
					$(innerElement).width(Control.getContentWidth() - ElementUtil.emToPx(1.5));
				}
			}
		});
		if (minHeightEm) {
			$(scrollPane).css("min-height", minHeightEm + "em");
		}
		if (fixHeightEm) {
			$(scrollPane).height(ElementUtil.emToPx(fixHeightEm < minHeightEm ? minHeigthEm : fixHeightEm));
		} else {
			if (offsetHeightEm) {
				var h = Control.getContentHeight() - ElementUtil.emToPx(offsetHeightEm);
				$(scrollPane).height(h < ElementUtil.emToPx(minHeightEm) ? ElementUtil.emToPx(minHeightEm) : h);
			} else {
				var h = Control.getContentHeight();
				$(scrollPane).height(h < ElementUtil.emToPx(minHeightEm) ? ElementUtil.emToPx(minHeightEm) : h);
			}
		}
		$(window).bind("resize.autoResizeScrollLayout.height" + innerElement, function() {
			if (fixHeightEm) {
				$(scrollPane).height(ElementUtil.emToPx(fixHeightEm < minHeightEm ? minHeigthEm : fixHeightEm));
			} else {
				if (offsetHeightEm) {
					var h = Control.getContentHeight() - ElementUtil.emToPx(offsetHeightEm);
					$(scrollPane).height(h < ElementUtil.emToPx(minHeightEm) ? ElementUtil.emToPx(minHeightEm) : h);
				} else {
					var h = Control.getContentHeight();
					$(scrollPane).height(h < ElementUtil.emToPx(minHeightEm) ? ElementUtil.emToPx(minHeightEm) : h);
				}
			}
		});
		$(window).resize();
		return true;
	},

	/**
	 * 指定された要素群でスクロールレイアウトのテーブルを構成します。<br>
	 * @param innerElement 内部要素セレクタ
	 * @param scrollPane スクロールdiv要素セレクタ
	 * @param headerPane ヘッダ部div要素セレクタ
	 * @param minWidthEm 最小幅em値(指定不要の場合はnull)
	 * @param minHeightEm 最小高さem値(指定不要の場合はnull)
	 * @param offsetWidthEm 画面幅からのオフセットem値
	 * @param offsetHeightEm 画面高さからのオフセットem値
	 * @returns 正常終了した場合はtrueを返却
	 */
	createScrollTableLayout : function(options) {
		var innerElement = options.innerElement;
		var scrollPane = options.scrollPane;
		var headerPane = options.headerPane;
		var minWidthEm = options.minWidthEm;
		var minHeightEm = options.minHeightEm;
		var offsetWidthEm = options.offsetWidthEm;
		var offsetHeightEm = options.offsetHeightEm;
		var fixWidthEm = options.fixWidthEm;
		var fixHeightEm = options.fixHeightEm;
		Control.setAutoResizeScrollLayout(innerElement, scrollPane, minWidthEm, minHeightEm, offsetWidthEm, offsetHeightEm, fixWidthEm, fixHeightEm);
		Control.setSyncTableHeaderScroll(scrollPane, headerPane);
		return true;
	},

	/**
	 * ダミーファンクション<br>
	 * InternetExplorerの場合、連想配列末尾にカンマが存在するとエラーとなることを回避<br>
	 */
	_ : function() {
	}
};
var Control = new _Control();
