<%@page pageEncoding="UTF-8"%>
<jsp:include page="/WEB-INF/view/common_layout/layout_header.jsp" flush="true">
	<jsp:param name="functionTitle" value="テスト" />
</jsp:include>

<form id="aa" method="post" action="/">
<fieldset class="fieldSet">
<legend>通常属性</legend>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキスト</label>
			<input type="text" id="testTextField" name="testTextField" class="ui-widget"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">パスワード</label>
			<input type="password" id="testPassword" class="ui-widget"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">ドロップダウン</label>
			<select id="testDropdown" class="ui-widget">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">チェックボックス</label>
			<label><input type="checkbox" id="testCheckbox1" class="ui-widget"/>チェックボックス1</label>
			<label><input type="checkbox" id="testCheckbox2" class="ui-widget"/>チェックボックス2</label>
			<label><input type="checkbox" id="testCheckbox3" class="ui-widget"/>チェックボックス3</label>
			<label><input type="checkbox" id="testCheckbox4" class="ui-widget"/>チェックボックス4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ラジオボタン</label>
			<label><input type="radio" id="testRadio1" name="testRadio" class="ui-widget"/>ラジオボタン1</label>
			<label><input type="radio" id="testRadio2" name="testRadio" class="ui-widget"/>ラジオボタン2</label>
			<label><input type="radio" id="testRadio3" name="testRadio" class="ui-widget"/>ラジオボタン3</label>
			<label><input type="radio" id="testRadio4" name="testRadio" class="ui-widget"/>ラジオボタン4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキストエリア</label>
			<textarea id="testTextField" class="ui-widget"></textarea>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(単選択)</label>
			<select id="testList" size="3" class="ui-widget">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(複数選択)</label>
			<select id="testMultipleList" size="3" multiple="multiple" draggable="true" class="ui-widget">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ファイル</label>
			<input type="file" id="testFile" class="ui-widget"/>
		</div>
	</div>
	<div class="buttonContainer">
		<input type="button" value="ボタン1"/>
		<input type="button" value="ボタン2"/>
		<input type="button" value="ボタン3"/>
	</div>
</fieldset>

<fieldset class="fieldSet">
<legend>Readonly属性</legend>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキスト</label>
			<input type="text" id="testTextFieldR" class="ui-widget" readonly="readonly"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">パスワード</label>
			<input type="password" id="testPasswordR" class="ui-widget" readonly="readonly"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">ドロップダウン</label>
			<select id="testDropdownR" class="ui-widget" readonly="readonly">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">チェックボックス</label>
			<label><input type="checkbox" id="testCheckboxR1" class="ui-widget" readonly="readonly"/>チェックボックス1</label>
			<label><input type="checkbox" id="testCheckboxR2" class="ui-widget" readonly="readonly"/>チェックボックス2</label>
			<label><input type="checkbox" id="testCheckboxR3" class="ui-widget" readonly="readonly"/>チェックボックス3</label>
			<label><input type="checkbox" id="testCheckboxR4" class="ui-widget" readonly="readonly"/>チェックボックス4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ラジオボタン</label>
			<label><input type="radio" id="testRadioR1" name="testRadioR" class="ui-widget" readonly="readonly"/>ラジオボタン1</label>
			<label><input type="radio" id="testRadioR2" name="testRadioR" class="ui-widget" readonly="readonly"/>ラジオボタン2</label>
			<label><input type="radio" id="testRadioR3" name="testRadioR" class="ui-widget" readonly="readonly"/>ラジオボタン3</label>
			<label><input type="radio" id="testRadioR4" name="testRadioR" class="ui-widget" readonly="readonly"/>ラジオボタン4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキストエリア</label>
			<textarea id="testTextFieldR" class="ui-widget" readonly="readonly"></textarea>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(単選択)</label>
			<select id="testListR" size="3" class="ui-widget" readonly="readonly">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(複数選択)</label>
			<select id="testMultipleListR" size="3" multiple="multiple" draggable="true" class="ui-widget" readonly="readonly">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ファイル</label>
			<input type="file" id="testFileR" class="ui-widget" readonly="readonly"/>
		</div>
	</div>
	<div class="buttonContainer">
		<input type="button" value="ボタン1" readonly="readonly"/>
		<input type="button" value="ボタン2" readonly="readonly"/>
		<input type="button" value="ボタン3" readonly="readonly"/>
	</div>
</fieldset>


<fieldset class="fieldSet">
<legend>Disabled属性</legend>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキスト</label>
			<input type="text" id="testTextFieldD" name="testTextFieldD" class="ui-widget" disabled="disabled"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">パスワード</label>
			<input type="password" id="testPasswordD" class="ui-widget" disabled="disabled"/>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">ドロップダウン</label>
			<select id="testDropdownD" class="ui-widget" disabled="disabled">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">チェックボックス</label>
			<label><input type="checkbox" id="testCheckboxD1" class="ui-widget" disabled="disabled"/>チェックボックス1</label>
			<label><input type="checkbox" id="testCheckboxD2" class="ui-widget" disabled="disabled"/>チェックボックス2</label>
			<label><input type="checkbox" id="testCheckboxD3" class="ui-widget" disabled="disabled"/>チェックボックス3</label>
			<label><input type="checkbox" id="testCheckboxD4" class="ui-widget" disabled="disabled"/>チェックボックス4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ラジオボタン</label>
			<label><input type="radio" id="testRadioD1" name="testRadioD" class="ui-widget" disabled="disabled"/>ラジオボタン1</label>
			<label><input type="radio" id="testRadioD2" name="testRadioD" class="ui-widget" disabled="disabled"/>ラジオボタン2</label>
			<label><input type="radio" id="testRadioD3" name="testRadioD" class="ui-widget" disabled="disabled"/>ラジオボタン3</label>
			<label><input type="radio" id="testRadioD4" name="testRadioD" class="ui-widget" disabled="disabled"/>ラジオボタン4</label>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">テキストエリア</label>
			<textarea id="testTextFieldD" class="ui-widget" disabled="disabled"></textarea>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(単選択)</label>
			<select id="testListD" size="3" class="ui-widget" disabled="disabled">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
		<div class="field">
			<label class="ui-widget-header fieldLabel">リスト(複数選択)</label>
			<select id="testMultipleListD" size="3" multiple="multiple" draggable="true" class="ui-widget" disabled="disabled">
				<option value="1">オプション1</option>
				<option value="2">オプション2</option>
				<option value="3">オプション3</option>
				<option value="4">オプション4</option>
				<option value="5">オプション5</option>
			</select>
		</div>
	</div>
	<div class="fieldLine">
		<div class="field">
			<label class="ui-widget-header fieldLabel">ファイル</label>
			<input type="file" id="testFileD" class="ui-widget" disabled="disabled"/>
		</div>
	</div>
	<div class="buttonContainer">
		<input type="button" value="ボタン1" disabled="disabled"/>
		<input type="button" value="ボタン2" disabled="disabled"/>
		<input type="button" value="ボタン3" disabled="disabled"/>
	</div>
</fieldset>
</form>

<jsp:include page="/WEB-INF/view/common_layout/layout_footer.jsp" flush="true">
	<jsp:param name="functionTitle" value="テスト" />
</jsp:include>
