<%@page pageEncoding="UTF-8" isErrorPage="true"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<%
/*
 * web.xmlによるエラーハンドリング遷移時のリクエストアトリビュート補完
 */
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_PROCESSDATE) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_PROCESSDATE, new java.util.Date());
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_ENVIRONMENT) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_ENVIRONMENT, org.phosphoresce.webcore.core.Environment.getMap());
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_CONFIG) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_CONFIG, org.phosphoresce.webcore.core.config.Config.getMap());
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_REQUEST) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_REQUEST, request);
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION, request.getAttribute("javax.servlet.jsp.jspException"));
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION, request.getAttribute("javax.servlet.error.exception"));
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION_TRACE) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION_TRACE, org.phosphoresce.lib.commons.util.ExceptionUtil.getStackTraceValue((Throwable) request.getAttribute("javax.servlet.jsp.jspException")));
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_EXCEPTION_TRACE, org.phosphoresce.lib.commons.util.ExceptionUtil.getStackTraceValue((Throwable) request.getAttribute("javax.servlet.error.exception")));
}
if (request.getAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_STATUS_CODE) == null) {
	request.setAttribute(org.phosphoresce.webcore.core.GlobalConstants.REQUEST_ATTR_KEY_STATUS_CODE, request.getAttribute("javax.servlet.error.status_code"));
}
%>
<html>
<head>
	<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=${f:cfg('common.charset.default')}" />
	<meta http-equiv="pragma" content="no-cache" />
	<meta http-equiv="cache-control" content="no-cache" />
	<meta http-equiv="expires" content="0" />
	<%--
	<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE8" />
	<meta http-equiv="X-UA-Compatible" content="IE=8" />
	--%>
	<%--
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no">
	<meta name="viewport" content="width=1000, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no">
	--%>
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, user-scalable=no">

	<link rel="shortcut icon" href="${f:res('/images/favicon-512x512.png')}" type="image/png" />

	<link type="text/css" rel="stylesheet" media="all" href="${f:res('/styles/general.css')}" />
	<link type="text/css" rel="stylesheet" media="all" href="${f:res('/styles/common.css')}" />
	<link type="text/css" rel="stylesheet" media="all" href="${f:res('/styles/layout.css')}" />

	<title>${f:h(f:cfg('common.application.title'))}</title>
</head>

<body>

<div
	class="hfill nomargin nopadding"
>
	<div
		class="contentUniform"
	>
		<div
			class="exceptionHeader"
		>
			<c:if test="${empty statusCode}">
			サーバーエラーが発生しました
			</c:if>
			<c:if test="${not empty statusCode}">
			サーバーエラーが発生しました(${f:h(statusCode)})
			</c:if>
		</div>
		<hr/>
		<div
			class="exceptionNotice"
		>
			このメッセージは、リクエストされた内容をサーバーが実行中に正常に処理できなかったことを意味します。<br/>
			再度、同じ処理を繰り返してもこのページが表示される場合は、システム管理者に連絡して下さい。<br/>
			(${f:fmDate(processDate, "yyyy/MM/dd HH:mm:ss")})<br/>
		</div>
		<hr/>
		<div
			class="exceptionSubHeader"
		>
			例外メッセージ
		</div>
		<div
			class="exceptionDescription"
		>
			<c:if test="${empty exception.message}">
				なし
			</c:if>
			<c:if test="${not empty exception.message}">
				${f:h(exception.message)}
			</c:if>
		</div>
		<hr/>
		<div
			class="exceptionSubHeader"
		>
			例外クラス
		</div>
		<div
			class="exceptionDescription"
		>
			<c:if test="${empty exception.class.name}">
				なし
			</c:if>
			<c:if test="${not empty exception.class.name}">
				${f:h(exception.class.name)}
			</c:if>
		</div>
		<hr/>
		<div
			class="exceptionSubHeader"
		>
			例外トレース情報
		</div>
		<div
			class="exceptionDescription"
		>
			<c:if test="${empty exceptionTrace}">
				なし
			</c:if>
			<c:if test="${not empty exceptionTrace}">
				${f:h(exceptionTrace)}
			</c:if>
		</div>
		<hr/>
	</div>
</div>

</body>
</html>
