package org.phosphoresce.lib.commons.util;

import java.util.Iterator;

/**
 * Javaランタイム関連に関するユーティリティクラス。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2007/05/17	Kitagawa		新規作成
 *-->
 */
public final class JavaUtil {

	/**
	 * コンストラクタ<br>
	 */
	private JavaUtil() {
		super();
	}

	/**
	 * システムプロパティの内容をシステムOutputStreamに対してトレースします。<br>
	 */
	public static void printProperties() {
		for (Iterator<Object> iterator = System.getProperties().keySet().iterator(); iterator.hasNext();) {
			String key = (String) iterator.next();
			System.out.println(key + " = " + System.getProperties().getProperty(key));
		}
	}

	/**
	 * 実行されているJavaバージョンが指定されたバージョン未満であるか判定します。<br>
	 * 実行バージョンが1.4.2で、指定値が142である場合はfalseが返却されます。<br>
	 * また、この場合に指定値を143とした場合はtrueが返却されます。<br>
	 * @param version チェックバージョン
	 * @return 指定バージョン未満のバージョンが実行Javaバージョンである場合はtrueを返却
	 */
	public static boolean isLessThanJavaVersion(int version) {
		int javaVersion = Integer.parseInt(System.getProperty("java.version").replaceAll("[.]", "").substring(0, 3));
		return javaVersion < version;
	}
}
