package org.phosphoresce.lib.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * 例外ユーティリティクラス。<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2005/11/22	Kitagawa		新規作成
 *-->
 */
public final class ExceptionUtil {

	/**
	 * コンストラクタ<br>
	 */
	private ExceptionUtil() {
		//
	}

	/**
	 * 指定されたThrowableオブジェクトのスタックトレースをStringオブジェクトとして取得します。<br>
	 * @param throwable Throwableオブジェクト
	 * @return スタックトレース
	 */
	public static String getStackTraceValue(Throwable throwable) {
		if (throwable == null) {
			return "";
		}

		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		throwable.printStackTrace(pw);

		String trace = sw.toString();

		pw.close();

		return trace;
	}
}
