package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.adapter.PoiCell;
import org.phosphoresce.commons.wpoi.adapter.PoiSheet;

/**
 * 動的オブジェクトバインド処理クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		バージョン2にアップデート(PoiDynaSheetから移管)
 *-->
 */
public class PoiDynaValueSetter {

	/** 処理対象シート */
	private PoiSheet sheet;

	/** 処理対象レンジ */
	private PoiDynaRange range;

	/** 動的値オブジェクトマップ */
	private PoiDynaMap dynaMap;

	/**
	 * コンストラクタ<br>
	 * @param sheet 処理対象シート
	 * @param dynaMap 動的値オブジェクトマップ
	 * @param range 処理対象レンジ
	 */
	PoiDynaValueSetter(PoiSheet sheet, PoiDynaMap dynaMap, PoiDynaRange range) {
		super();
		this.sheet = sheet;
		this.range = range;
		this.dynaMap = dynaMap;
	}

	/**
	 * コンストラクタ<br>
	 * @param sheet 処理対象シート
	 * @param dynaMap 動的値オブジェクトマップ
	 */
	public PoiDynaValueSetter(PoiSheet sheet, PoiDynaMap dynaMap) {
		this(sheet, dynaMap, new PoiDynaRange(0, 0, sheet.getLastRowNum(), sheet.getLastCellNum()));
	}

	/**
	 * バインド処理を行います。<br>
	 */
	public void execute() {
		/*
		 * 処理対象レンジ範囲内処理イテレート
		 */
		while (range.hasMoreProcessRow()) {
			// 識別用先頭セル取得
			PoiCell headCell = sheet.getCell(range.getProcessPoint().getProcessRowIndex(), range.getProcessPoint().getProcessColIndex());

			if (PoiDynaUtil.isDynaListStartCell(headCell)) {
				/*
				 * リスト開始指示行の場合はリスト動的バインド処理に委譲
				 */
				PoiDynaRange newRange = new PoiDynaRange(range, range.getProcessPoint().getProcessRowIndex(), range.getColIndexFrom(), PoiDynaUtil.getListEndIndex(headCell, range), range.getColIndexTo());
				new PoiDynaValueListSetter(sheet, dynaMap.getDynaList(PoiDynaUtil.getDynaKey(headCell)), newRange).execute();
			} else {
				/*
				 * リスト開始行以外は通常動的行バインド処理に委譲
				 */
				new PoiDynaValueRowSetter(sheet.getRow(range.getProcessPoint().getProcessRowIndex()), dynaMap, range).execute();
			}
		}
	}
}
