package org.phosphoresce.commons.wpoi.dyna;

import java.io.Serializable;

/**
 * 動的設定一位置情報クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
class PoiDynaPoint implements Serializable {

	/** 処理行位置 */
	private int processRowIndex;

	/** 処理列位置 */
	private int processColIndex;

	/**
	 * コンストラクタ<br>
	 * @param processRowIndex 行終了位置(0～)
	 * @param processColIndex 列終了位置(0～)
	 */
	public PoiDynaPoint(int processRowIndex, int processColIndex) {
		super();
		this.processRowIndex = processRowIndex;
		this.processColIndex = processColIndex;
	}

	/**
	 * 処理行位置を取得します。<br>
	 * @return 処理行位置
	 */
	public int getProcessRowIndex() {
		return processRowIndex;
	}

	/**
	 * 処理行位置を設定します。<br>
	 * @param processRowIndex 処理行位置
	 */
	public void setProcessRowIndex(int processRowIndex) {
		this.processRowIndex = processRowIndex;
	}

	/**
	 * 処理列位置を取得します。<br>
	 * @return 処理列位置
	 */
	public int getProcessColIndex() {
		return processColIndex;
	}

	/**
	 * 処理列位置を設定します。<br>
	 * @param processColIndex 処理列位置
	 */
	public void setProcessColIndex(int processColIndex) {
		this.processColIndex = processColIndex;
	}

	/**
	 * ハッシュコードを取得します。<br>
	 * @return ハッシュコード
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + processColIndex;
		result = prime * result + processRowIndex;
		return result;
	}

	/**
	 * オブジェクト等価比較を行います。<br>
	 * @return 等価の場合にtrueを返却
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		PoiDynaPoint other = (PoiDynaPoint) object;
		if (processColIndex != other.processColIndex) {
			return false;
		}
		if (processRowIndex != other.processRowIndex) {
			return false;
		}
		return true;
	}

	/**
	 * クラス情報を文字列で取得します。<br>
	 * @return クラス情報文字列
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("{");
		builder.append("processRowIndex=");
		builder.append(processRowIndex);
		builder.append(", ");
		builder.append("processColIndex=");
		builder.append(processColIndex);
		builder.append("}");
		return builder.toString();
	}
}
