package org.phosphoresce.commons.wpoi.dyna;

import org.phosphoresce.commons.wpoi.PoiGlobal;

/**
 * 動的バインドオブジェクトクラス<br>
 * 
 * @author kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2012/07/09	Kitagawa		新規作成(バージョン2にアップデート)
 *-->
 */
public class PoiDynaObject implements PoiGlobal, PoiDynaValue {

	/** バインドオブジェクト */
	private Object value;

	/**
	 * コンストラクタ<br>
	 * @param value バインド値
	 */
	public PoiDynaObject(Object value) {
		super();
		this.value = value;
	}

	/**
	 * コンストラクタ<br>
	 */
	public PoiDynaObject() {
		this(null);
	}

	/**
	 * バインド値タイプを取得します。<br>
	 * @return バインド値タイプ
	 * @see org.phosphoresce.commons.wpoi.dyna.PoiDynaValue#getDynaValueType()
	 */
	public int getDynaValueType() {
		return TYPE_OBJECT;
	}

	/**
	 * バインドオブジェクトを取得します。<br>
	 * @return バインドオブジェクト
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * バインドオブジェクトを設定します。<br>
	 * @param value バインドオブジェクト
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * クラス情報を文字列で取得します。<br>
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return value == null ? "null" : value.toString();
	}
}
