package org.phosphoresce.commons.wpoi.dyna;

import java.util.HashMap;

import org.phosphoresce.commons.wpoi.PoiGlobal;

/**
 * 動的バインドマップクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2005/11/21	Kitagawa		新規作成
 * 2012/07/09	Kitagawa		バージョン2にアップデート
 *-->
 */
public class PoiDynaMap extends HashMap<String, PoiDynaValue> implements PoiGlobal {

	/**
	 * コンストラクタ<br>
	 */
	public PoiDynaMap() {
		super();
	}

	/**
	 * 動的バインドオブジェクトを取得します。<br>
	 * @param key キー
	 * @return 動的バインドオブジェクト
	 */
	public PoiDynaObject getDynaObject(String key) {
		return (PoiDynaObject) get(key);
	}

	/**
	 * 動的バインドリストを取得します。<br>
	 * @param key キー
	 * @return 動的バインドリスト
	 */
	public PoiDynaList getDynaList(String key) {
		return (PoiDynaList) get(key);
	}

	/**
	 * 指定されたキーで保持されているデータがバインドオブジェクトタイプであるか判定します。<br>
	 * @param key キー
	 * @return バインドオブジェクトタイプである場合にtrueを返却
	 */
	public boolean isDynaObject(String key) {
		return get(key) == null ? false : get(key).getDynaValueType() == PoiDynaValue.TYPE_OBJECT;
	}

	/**
	 * 指定されたキーで保持されているデータがバインドリストタイプであるか判定します。<br>
	 * @param key キー
	 * @return バインドリストタイプである場合にtrueを返却
	 */
	public boolean isDynaList(String key) {
		return get(key) == null ? false : get(key).getDynaValueType() == PoiDynaValue.TYPE_LIST;
	}
}
