package org.phosphoresce.library.wpoi.test.model;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.library.wpoi.test.util.CommonUtils;

/**
 * TvNX<br>
 * f[^f<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV       XV          XVe
 * 2005/12/07	Kitagawa		VK쐬
 *-->
 */
public final class Project extends Model {

	/** vWFNgR[h */
	private String code;

	/** vWFNg */
	private String name;

	/** vWFNgǊ */
	private Section[] sections;

	/** vWFNgo[ */
	private Employee[] members;

	/** vWFNg}l[W[ */
	private Employee manager;

	/** \Z */
	private Long budget;

	/** vWFNgJn */
	private Date startDate;

	/** vWFNgI */
	private Date finishDate;

	/** vWFNgItO */
	private boolean closed;

	/**
	 * RXgN^<br>
	 * @param code vWFNgR[h
	 * @param name vWFNg
	 */
	public Project(String code, String name) {
		super();
		this.code = code;
		this.name = name;
	}

	/**
	 * Ǌǉ܂B<br>
	 * @param section Ǌ
	 */
	public void addSection(Section section) {
		List buffer = new LinkedList(Arrays.asList(getSections()));
		if (section != null && !buffer.contains(section)) {
			buffer.add(section);
		}
		sections = (Section[]) CommonUtils.castArray(Section.class, buffer);
	}

	/**
	 * vWFNgo[ǉ܂B<br>
	 * @param employee vWFNgo[
	 */
	public void addMember(Employee employee) {
		List buffer = new LinkedList(Arrays.asList(getMembers()));
		if (employee != null && !buffer.contains(employee)) {
			buffer.add(employee);
		}
		members = (Employee[]) CommonUtils.castArray(Employee.class, buffer);
	}

	/**
	 * vWFNgR[h擾܂B<br>
	 * @return vWFNgR[h
	 */
	public String getCode() {
		return code;
	}

	/**
	 * vWFNgR[hݒ肵܂B<br>
	 * @param code vWFNgR[h
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * vWFNgo[擾܂B<br>
	 * @return vWFNgo[
	 */
	public Employee[] getMembers() {
		return members == null ? new Employee[] {} : members;
	}

	/**
	 * vWFNg擾܂B<br>
	 * @return vWFNg
	 */
	public String getName() {
		return name;
	}

	/**
	 * vWFNgݒ肵܂B<br>
	 * @param name vWFNg
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * Ǌ擾܂B<br>
	 * @return Ǌ
	 */
	public Section[] getSections() {
		return sections == null ? new Section[] {} : sections;
	}

	/**
	 * vWFNg}l[W擾܂B<br>
	 * @return vWFNg}l[W
	 */
	public Employee getManager() {
		return manager;
	}

	/**
	 * vWFNg}l[Wݒ肵܂B<br>
	 * @param manager vWFNg}l[W
	 */
	public void setManager(Employee manager) {
		this.manager = manager;
	}

	/**
	 * \Z擾܂B<br>
	 * @return \Z
	 */
	public Long getBudget() {
		return budget;
	}

	/**
	 * \Zݒ肵܂B<br>
	 * @param budget \Z
	 */
	public void setBudget(Long budget) {
		this.budget = budget;
	}

	/**
	 * vWFNgItO擾܂B<br>
	 * @return vWFNgItO
	 */
	public boolean isClosed() {
		return closed;
	}

	/**
	 * vWFNgItOݒ肵܂B<br>
	 * @param closed vWFNgItO
	 */
	public void setClosed(boolean closed) {
		this.closed = closed;
	}

	/**
	 * vWFNgI擾܂B<br>
	 * @return vWFNgI
	 */
	public Date getFinishDate() {
		return finishDate;
	}

	/**
	 * vWFNgIݒ肵܂B<br>
	 * @param finishDate vWFNgI
	 */
	public void setFinishDate(Date finishDate) {
		this.finishDate = finishDate;
	}

	/**
	 * vWFNgJn擾܂B<br>
	 * @return vWFNgJn
	 */
	public Date getStartDate() {
		return startDate;
	}

	/**
	 * vWFNgJnݒ肵܂B<br>
	 * @param startDate vWFNgJn
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}
}
