package org.phosphoresce.commons.wpoi.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.phosphoresce.commons.wpoi.exception.PoiException;

/**
 * POIZNXB<br>
 * org.apache.poi.hssf.usermodel.HSSFRow̐ƎȃC^tF[XyсA
 * sێA񋟂邱ƂړIƂNXB<br>
 * HSSFRowɑ΂SĂ̐C^tF[X͎ȂׁAg
 * HSSFRowIuWFNg̎擾\bh͓NXɎB<br>
 * NX̃CX^XPoiSheet񋟂̂
 * [UӐ}IɃCX^X𐶐邱Ƃ͑z肵ȂB<br>
 * 
 * @author last modified by: Kitagawa<br>
 * LastUpdate: 2005/11/21
 * 
 *<!--
 * XV       XV          XVe
 * 2005/11/21	Kitagawa		VK쐬
 *-->
 */
public final class PoiRow {

	/** MOIuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** PoiWorkbookIuWFNgCX^X */
	private PoiWorkbook pWorkbook;

	/** PoiSheetIuWFNgCX^X */
	private PoiSheet pSheet;

	/** gHSSFRowIuWFNg */
	private HSSFRow hssfRow;

	/**
	 * RXgN^<br>
	 */
	private PoiRow() {
		//
	}

	/**
	 * RXgN^<br>
	 * @param pWorkbook PoiWorkbookIuWFNg
	 * @param pSheet PoiSheetIuWFNg
	 * @param hssfRow HSSFRowIuWFNg
	 */
	protected PoiRow(PoiWorkbook pWorkbook, PoiSheet pSheet, HSSFRow hssfRow) {
		this.pWorkbook = pWorkbook;
		this.pSheet = pSheet;
		this.hssfRow = hssfRow;
	}

	/**
	 * gHSSFRowIuWFNg擾܂B<br>
	 * @return HSSFRowIuWFNg
	 */
	protected HSSFRow getHssfRow() {
		return hssfRow;
	}

	/**
	 * w肳ꂽJʒuPoiCellIuWFNg擾܂B<br>
	 * fourceInstancetruew肳ĂHSSFCellnull̏ꍇA
	 * VKHSSFCellCX^X𐶐܂B<br>
	 * AAgHSSFRowCX^X݂邱ƂOłB<br>
	 * @param col Jʒu
	 * @param fourceInstance Ώۂ̃Znull̏ꍇɋIɃCX^X𐶐ꍇtruew
	 * @return PoiCellIuWFNg
	 */
	public PoiCell getPoiCell(short col, boolean fourceInstance) {
		if (hssfRow == null) {
			return null;
		} else {
			if (hssfRow.getCell(col) == null) {
				if (fourceInstance) {
					return new PoiCell(pWorkbook, pSheet, this, hssfRow.createCell(col));
				} else {
					return null;
				}
			} else {
				return new PoiCell(pWorkbook, pSheet, this, hssfRow.getCell(col));
			}
		}
	}

	/**
	 * w肳ꂽJʒuPoiCellIuWFNg擾܂B<br>
	 * @param col Jʒu
	 * @return PoiCellIuWFNg
	 */
	public PoiCell getPoiCell(short col) {
		return getPoiCell(col, false);
	}

	/**
	 * sێő̃Jʒu擾܂B<br>
	 * AAgHSSFRowIuWFNgnull̏ꍇ͕ԋp܂B<br>
	 * @return sێő̃Jʒu
	 */
	public short getLastColNum() {
		if (hssfRow == null) {
			return -1;
		}

		return hssfRow.getLastCellNum();
	}

	/**
	 * g̍s̍sʒu擾܂B<br>
	 * eV[gIuWFNg玩g̍słĂꍇA
	 * ܂͍snull̏ꍇɂ͕ԋp܂B<br>
	 * @return g̍s̍sʒu
	 */
	public int getRowNum() throws PoiException {
		if (hssfRow == null) {
			return -1;
		}

		for (int i = 0; i <= pSheet.getLastRowNum(); i++) {
			if (hssfRow.equals(pSheet.getPoiRow(i, true).getHssfRow())) {
				return i;
			}
		}

		return -1;
	}
}
