package org.phosphoresce.commons.socket.http.container;

import org.phosphoresce.commons.socket.http.container.HttpSocketRequest;

import junit.framework.TestCase;

/**
 * TODO クラス説明。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/14	Kitagawa		新規作成
 *-->
 */
public class TestHttpSocketRequest extends TestCase {

	public void testConstructor01() {
		HttpSocketRequest request = new HttpSocketRequest();
		assertEquals("", request.getMethod());
		assertEquals("", request.getPath());
		assertEquals("", request.getProtocol());
		assertEquals("", request.getVersion());
		assertEquals("", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testSetMethod01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.setMethod("GET");
		assertEquals("GET", request.getMethod());
		assertEquals("", request.getPath());
		assertEquals("", request.getProtocol());
		assertEquals("", request.getVersion());
		assertEquals("GET", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testSetPath01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.setMethod("GET");
		request.setPath("/");
		assertEquals("GET", request.getMethod());
		assertEquals("/", request.getPath());
		assertEquals("", request.getProtocol());
		assertEquals("", request.getVersion());
		assertEquals("GET /", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testSetProtocol01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.setMethod("GET");
		request.setPath("/");
		request.setProtocol("HTTP");
		assertEquals("GET", request.getMethod());
		assertEquals("/", request.getPath());
		assertEquals("HTTP", request.getProtocol());
		assertEquals("", request.getVersion());
		assertEquals("GET / HTTP", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testSetVersion01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.setMethod("GET");
		request.setPath("/");
		request.setProtocol("HTTP");
		request.setVersion("1.1");
		assertEquals("GET", request.getMethod());
		assertEquals("/", request.getPath());
		assertEquals("HTTP", request.getProtocol());
		assertEquals("1.1", request.getVersion());
		assertEquals("GET / HTTP/1.1", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testSetIdentifier01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.setIdentifier("POST /test HTTP/1.0");
		assertEquals("POST", request.getMethod());
		assertEquals("/test", request.getPath());
		assertEquals("HTTP", request.getProtocol());
		assertEquals("1.0", request.getVersion());
		assertEquals("POST /test HTTP/1.0", request.getIdentifier());
		assertEquals(0, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
	}

	public void testAddHeader01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addHeader("Host: localhost");
		assertEquals(1, request.getHeaders().size());
		assertEquals(0, request.getCookies().size());
		assertEquals("localhost", request.getHeader("host").getValue());
	}

	public void testAddHeader02() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addHeader("Cookie: foo=bar");
		assertEquals(0, request.getHeaders().size());
		assertEquals(1, request.getCookies().size());
		assertEquals("bar", request.getCookie("foo").getValue());
	}

	public void testAddHeader03() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addHeader("Cookie: foo=bar;hoge=hoge");
		assertEquals(0, request.getHeaders().size());
		assertEquals(2, request.getCookies().size());
		assertEquals("bar", request.getCookie("foo").getValue());
		assertEquals("hoge", request.getCookie("hoge").getValue());
	}

	public void testAddCookie01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addCookie("foo=bar");
		assertEquals(0, request.getHeaders().size());
		assertEquals(1, request.getCookies().size());
		assertEquals("bar", request.getCookie("foo").getValue());
	}

	public void testAddCookie02() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addCookie("foo=bar; hoge=hoge;");
		assertEquals(0, request.getHeaders().size());
		assertEquals(2, request.getCookies().size());
		assertEquals("bar", request.getCookie("foo").getValue());
		assertEquals("hoge", request.getCookie("hoge").getValue());
	}

	public void testGetHeaderStrings01() {
		HttpSocketRequest request = new HttpSocketRequest();
		request.addHeader("Host: localhost");
		request.addHeader("Cookie: foo=bar");
		assertEquals(1, request.getHeaderStrings().length);
		String[] compares = new String[] { "Host: localhost", "Cookie: foo=bar" };
		for (int i = 0; i <= request.getHeaderStrings().length - 1; i++) {
			assertEquals(compares[i], request.getHeaderStrings()[i]);
		}
	}
}
