package org.phosphoresce.commons.socket.http;

/**
 * MIMEマッピング列挙型クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/20	Kitagawa		新規作成
 *-->
 */
public class HttpMimeMapping {

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping ABS = new HttpMimeMapping("abs", "audio/x-mpeg");

	/** MIMEタイプ(application/postscript) */
	public static final HttpMimeMapping AI = new HttpMimeMapping("ai", "application/postscript");

	/** MIMEタイプ(audio/x-aiff) */
	public static final HttpMimeMapping AIF = new HttpMimeMapping("aif", "audio/x-aiff");

	/** MIMEタイプ(audio/x-aiff) */
	public static final HttpMimeMapping AIFC = new HttpMimeMapping("aifc", "audio/x-aiff");

	/** MIMEタイプ(audio/x-aiff) */
	public static final HttpMimeMapping AIFF = new HttpMimeMapping("aiff", "audio/x-aiff");

	/** MIMEタイプ(application/x-aim) */
	public static final HttpMimeMapping AIM = new HttpMimeMapping("aim", "application/x-aim");

	/** MIMEタイプ(image/x-jg) */
	public static final HttpMimeMapping ART = new HttpMimeMapping("art", "image/x-jg");

	/** MIMEタイプ(video/x-ms-asf) */
	public static final HttpMimeMapping ASF = new HttpMimeMapping("asf", "video/x-ms-asf");

	/** MIMEタイプ(video/x-ms-asf) */
	public static final HttpMimeMapping ASX = new HttpMimeMapping("asx", "video/x-ms-asf");

	/** MIMEタイプ(audio/basic) */
	public static final HttpMimeMapping AU = new HttpMimeMapping("au", "audio/basic");

	/** MIMEタイプ(video/x-msvideo) */
	public static final HttpMimeMapping AVI = new HttpMimeMapping("avi", "video/x-msvideo");

	/** MIMEタイプ(video/x-rad-screenplay) */
	public static final HttpMimeMapping AVX = new HttpMimeMapping("avx", "video/x-rad-screenplay");

	/** MIMEタイプ(application/x-bcpio) */
	public static final HttpMimeMapping BCPIO = new HttpMimeMapping("bcpio", "application/x-bcpio");

	/** MIMEタイプ(application/octet-stream) */
	public static final HttpMimeMapping BIN = new HttpMimeMapping("bin", "application/octet-stream");

	/** MIMEタイプ(image/bmp) */
	public static final HttpMimeMapping BMP = new HttpMimeMapping("bmp", "image/bmp");

	/** MIMEタイプ(text/html) */
	public static final HttpMimeMapping BODY = new HttpMimeMapping("body", "text/html");

	/** MIMEタイプ(application/x-cdf) */
	public static final HttpMimeMapping CDF = new HttpMimeMapping("cdf", "application/x-cdf");

	/** MIMEタイプ(application/x-x509-ca-cert) */
	public static final HttpMimeMapping CER = new HttpMimeMapping("cer", "application/x-x509-ca-cert");

	/** MIMEタイプ(application/java) */
	public static final HttpMimeMapping CLASS = new HttpMimeMapping("class", "application/java");

	/** MIMEタイプ(application/x-cpio) */
	public static final HttpMimeMapping CPIO = new HttpMimeMapping("cpio", "application/x-cpio");

	/** MIMEタイプ(application/x-csh) */
	public static final HttpMimeMapping CSH = new HttpMimeMapping("csh", "application/x-csh");

	/** MIMEタイプ(text/css) */
	public static final HttpMimeMapping CSS = new HttpMimeMapping("css", "text/css");

	/** MIMEタイプ(image/bmp) */
	public static final HttpMimeMapping DIB = new HttpMimeMapping("dib", "image/bmp");

	/** MIMEタイプ(application/msword) */
	public static final HttpMimeMapping DOC = new HttpMimeMapping("doc", "application/msword");

	/** MIMEタイプ(text/plain) */
	public static final HttpMimeMapping DTD = new HttpMimeMapping("dtd", "text/plain");

	/** MIMEタイプ(video/x-dv) */
	public static final HttpMimeMapping DV = new HttpMimeMapping("dv", "video/x-dv");

	/** MIMEタイプ(application/x-dvi) */
	public static final HttpMimeMapping DVI = new HttpMimeMapping("dvi", "application/x-dvi");

	/** MIMEタイプ(application/postscript) */
	public static final HttpMimeMapping EPS = new HttpMimeMapping("eps", "application/postscript");

	/** MIMEタイプ(text/x-setext) */
	public static final HttpMimeMapping ETX = new HttpMimeMapping("etx", "text/x-setext");

	/** MIMEタイプ(application/octet-stream) */
	public static final HttpMimeMapping EXE = new HttpMimeMapping("exe", "application/octet-stream");

	/** MIMEタイプ(image/gif) */
	public static final HttpMimeMapping GIF = new HttpMimeMapping("gif", "image/gif");

	/** MIMEタイプ(application/x-gtar) */
	public static final HttpMimeMapping GTAR = new HttpMimeMapping("gtar", "application/x-gtar");

	/** MIMEタイプ(application/x-gzip) */
	public static final HttpMimeMapping GZ = new HttpMimeMapping("gz", "application/x-gzip");

	/** MIMEタイプ(application/x-hdf) */
	public static final HttpMimeMapping HDF = new HttpMimeMapping("hdf", "application/x-hdf");

	/** MIMEタイプ(application/mac-binhex40) */
	public static final HttpMimeMapping HQX = new HttpMimeMapping("hqx", "application/mac-binhex40");

	/** MIMEタイプ(text/x-component) */
	public static final HttpMimeMapping HTC = new HttpMimeMapping("htc", "text/x-component");

	/** MIMEタイプ(text/html) */
	public static final HttpMimeMapping HTM = new HttpMimeMapping("htm", "text/html");

	/** MIMEタイプ(text/html) */
	public static final HttpMimeMapping HTML = new HttpMimeMapping("html", "text/html");

	/** MIMEタイプ(image/ief) */
	public static final HttpMimeMapping IEF = new HttpMimeMapping("ief", "image/ief");

	/** MIMEタイプ(text/vnd.sun.j2me.app-descriptor) */
	public static final HttpMimeMapping JAD = new HttpMimeMapping("jad", "text/vnd.sun.j2me.app-descriptor");

	/** MIMEタイプ(application/java-archive) */
	public static final HttpMimeMapping JAR = new HttpMimeMapping("jar", "application/java-archive");

	/** MIMEタイプ(text/plain) */
	public static final HttpMimeMapping JAVA = new HttpMimeMapping("java", "text/plain");

	/** MIMEタイプ(application/x-java-jnlp-file) */
	public static final HttpMimeMapping JNLP = new HttpMimeMapping("jnlp", "application/x-java-jnlp-file");

	/** MIMEタイプ(image/jpeg) */
	public static final HttpMimeMapping JPE = new HttpMimeMapping("jpe", "image/jpeg");

	/** MIMEタイプ(image/jpeg) */
	public static final HttpMimeMapping JPEG = new HttpMimeMapping("jpeg", "image/jpeg");

	/** MIMEタイプ(image/jpeg) */
	public static final HttpMimeMapping JPG = new HttpMimeMapping("jpg", "image/jpeg");

	/** MIMEタイプ(text/javascript) */
	public static final HttpMimeMapping JS = new HttpMimeMapping("js", "text/javascript");

	/** MIMEタイプ(text/plain) */
	public static final HttpMimeMapping JSF = new HttpMimeMapping("jsf", "text/plain");

	/** MIMEタイプ(text/plain) */
	public static final HttpMimeMapping JSPF = new HttpMimeMapping("jspf", "text/plain");

	/** MIMEタイプ(audio/x-midi) */
	public static final HttpMimeMapping KAR = new HttpMimeMapping("kar", "audio/x-midi");

	/** MIMEタイプ(application/x-latex) */
	public static final HttpMimeMapping LATEX = new HttpMimeMapping("latex", "application/x-latex");

	/** MIMEタイプ(audio/x-mpegurl) */
	public static final HttpMimeMapping M3U = new HttpMimeMapping("m3u", "audio/x-mpegurl");

	/** MIMEタイプ(image/x-macpaint) */
	public static final HttpMimeMapping MAC = new HttpMimeMapping("mac", "image/x-macpaint");

	/** MIMEタイプ(application/x-troff-man) */
	public static final HttpMimeMapping MAN = new HttpMimeMapping("man", "application/x-troff-man");

	/** MIMEタイプ(application/x-troff-me) */
	public static final HttpMimeMapping ME = new HttpMimeMapping("me", "application/x-troff-me");

	/** MIMEタイプ(audio/x-midi) */
	public static final HttpMimeMapping MID = new HttpMimeMapping("mid", "audio/x-midi");

	/** MIMEタイプ(audio/x-midi) */
	public static final HttpMimeMapping MIDI = new HttpMimeMapping("midi", "audio/x-midi");

	/** MIMEタイプ(application/x-mif) */
	public static final HttpMimeMapping MIF = new HttpMimeMapping("mif", "application/x-mif");

	/** MIMEタイプ(video/quicktime) */
	public static final HttpMimeMapping MOV = new HttpMimeMapping("mov", "video/quicktime");

	/** MIMEタイプ(video/x-sgi-movie) */
	public static final HttpMimeMapping MOVIE = new HttpMimeMapping("movie", "video/x-sgi-movie");

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping MP1 = new HttpMimeMapping("mp1", "audio/x-mpeg");

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping MP2 = new HttpMimeMapping("mp2", "audio/x-mpeg");

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping MP3 = new HttpMimeMapping("mp3", "audio/x-mpeg");

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping MPA = new HttpMimeMapping("mpa", "audio/x-mpeg");

	/** MIMEタイプ(video/mpeg) */
	public static final HttpMimeMapping MPE = new HttpMimeMapping("mpe", "video/mpeg");

	/** MIMEタイプ(video/mpeg) */
	public static final HttpMimeMapping MPEG = new HttpMimeMapping("mpeg", "video/mpeg");

	/** MIMEタイプ(audio/x-mpeg) */
	public static final HttpMimeMapping MPEGA = new HttpMimeMapping("mpega", "audio/x-mpeg");

	/** MIMEタイプ(video/mpeg) */
	public static final HttpMimeMapping MPG = new HttpMimeMapping("mpg", "video/mpeg");

	/** MIMEタイプ(video/mpeg2) */
	public static final HttpMimeMapping MPV2 = new HttpMimeMapping("mpv2", "video/mpeg2");

	/** MIMEタイプ(application/x-wais-source) */
	public static final HttpMimeMapping MS = new HttpMimeMapping("ms", "application/x-wais-source");

	/** MIMEタイプ(application/x-netcdf) */
	public static final HttpMimeMapping NC = new HttpMimeMapping("nc", "application/x-netcdf");

	/** MIMEタイプ(application/oda) */
	public static final HttpMimeMapping ODA = new HttpMimeMapping("oda", "application/oda");

	/** MIMEタイプ(image/x-portable-bitmap) */
	public static final HttpMimeMapping PBM = new HttpMimeMapping("pbm", "image/x-portable-bitmap");

	/** MIMEタイプ(image/pict) */
	public static final HttpMimeMapping PCT = new HttpMimeMapping("pct", "image/pict");

	/** MIMEタイプ(application/pdf) */
	public static final HttpMimeMapping PDF = new HttpMimeMapping("pdf", "application/pdf");

	/** MIMEタイプ(image/x-portable-graymap) */
	public static final HttpMimeMapping PGM = new HttpMimeMapping("pgm", "image/x-portable-graymap");

	/** MIMEタイプ(image/pict) */
	public static final HttpMimeMapping PIC = new HttpMimeMapping("pic", "image/pict");

	/** MIMEタイプ(image/pict) */
	public static final HttpMimeMapping PICT = new HttpMimeMapping("pict", "image/pict");

	/** MIMEタイプ(audio/x-scpls) */
	public static final HttpMimeMapping PLS = new HttpMimeMapping("pls", "audio/x-scpls");

	/** MIMEタイプ(image/png) */
	public static final HttpMimeMapping PNG = new HttpMimeMapping("png", "image/png");

	/** MIMEタイプ(image/x-portable-anymap) */
	public static final HttpMimeMapping PNM = new HttpMimeMapping("pnm", "image/x-portable-anymap");

	/** MIMEタイプ(image/x-macpaint) */
	public static final HttpMimeMapping PNT = new HttpMimeMapping("pnt", "image/x-macpaint");

	/** MIMEタイプ(image/x-portable-pixmap) */
	public static final HttpMimeMapping PPM = new HttpMimeMapping("ppm", "image/x-portable-pixmap");

	/** MIMEタイプ(application/powerpoint) */
	public static final HttpMimeMapping PPT = new HttpMimeMapping("ppt", "application/powerpoint");

	/** MIMEタイプ(application/postscript) */
	public static final HttpMimeMapping PS = new HttpMimeMapping("ps", "application/postscript");

	/** MIMEタイプ(image/x-photoshop) */
	public static final HttpMimeMapping PSD = new HttpMimeMapping("psd", "image/x-photoshop");

	/** MIMEタイプ(video/quicktime) */
	public static final HttpMimeMapping QT = new HttpMimeMapping("qt", "video/quicktime");

	/** MIMEタイプ(image/x-quicktime) */
	public static final HttpMimeMapping QTI = new HttpMimeMapping("qti", "image/x-quicktime");

	/** MIMEタイプ(image/x-quicktime) */
	public static final HttpMimeMapping QTIF = new HttpMimeMapping("qtif", "image/x-quicktime");

	/** MIMEタイプ(image/x-cmu-raster) */
	public static final HttpMimeMapping RAS = new HttpMimeMapping("ras", "image/x-cmu-raster");

	/** MIMEタイプ(image/x-rgb) */
	public static final HttpMimeMapping RGB = new HttpMimeMapping("rgb", "image/x-rgb");

	/** MIMEタイプ(application/vnd.rn-realmedia) */
	public static final HttpMimeMapping RM = new HttpMimeMapping("rm", "application/vnd.rn-realmedia");

	/** MIMEタイプ(application/x-troff) */
	public static final HttpMimeMapping ROFF = new HttpMimeMapping("roff", "application/x-troff");

	/** MIMEタイプ(application/rtf) */
	public static final HttpMimeMapping RTF = new HttpMimeMapping("rtf", "application/rtf");

	/** MIMEタイプ(text/richtext) */
	public static final HttpMimeMapping RTX = new HttpMimeMapping("rtx", "text/richtext");

	/** MIMEタイプ(application/x-sh) */
	public static final HttpMimeMapping SH = new HttpMimeMapping("sh", "application/x-sh");

	/** MIMEタイプ(application/x-shar) */
	public static final HttpMimeMapping SHAR = new HttpMimeMapping("shar", "application/x-shar");

	/** MIMEタイプ(audio/x-midi) */
	public static final HttpMimeMapping SMF = new HttpMimeMapping("smf", "audio/x-midi");

	/** MIMEタイプ(application/x-stuffit) */
	public static final HttpMimeMapping SIT = new HttpMimeMapping("sit", "application/x-stuffit");

	/** MIMEタイプ(audio/basic) */
	public static final HttpMimeMapping SND = new HttpMimeMapping("snd", "audio/basic");

	/** MIMEタイプ(application/x-wais-source) */
	public static final HttpMimeMapping SRC = new HttpMimeMapping("src", "application/x-wais-source");

	/** MIMEタイプ(application/x-sv4cpio) */
	public static final HttpMimeMapping SV4CPIO = new HttpMimeMapping("sv4cpio", "application/x-sv4cpio");

	/** MIMEタイプ(application/x-sv4crc) */
	public static final HttpMimeMapping SV4CRC = new HttpMimeMapping("sv4crc", "application/x-sv4crc");

	/** MIMEタイプ(application/x-shockwave-flash) */
	public static final HttpMimeMapping SWF = new HttpMimeMapping("swf", "application/x-shockwave-flash");

	/** MIMEタイプ(application/x-troff) */
	public static final HttpMimeMapping T = new HttpMimeMapping("t", "application/x-troff");

	/** MIMEタイプ(application/x-tar) */
	public static final HttpMimeMapping TAR = new HttpMimeMapping("tar", "application/x-tar");

	/** MIMEタイプ(application/x-tcl) */
	public static final HttpMimeMapping TCL = new HttpMimeMapping("tcl", "application/x-tcl");

	/** MIMEタイプ(application/x-tex) */
	public static final HttpMimeMapping TEX = new HttpMimeMapping("tex", "application/x-tex");

	/** MIMEタイプ(application/x-texinfo) */
	public static final HttpMimeMapping TEXI = new HttpMimeMapping("texi", "application/x-texinfo");

	/** MIMEタイプ(application/x-texinfo) */
	public static final HttpMimeMapping TEXINFO = new HttpMimeMapping("texinfo", "application/x-texinfo");

	/** MIMEタイプ(image/tiff) */
	public static final HttpMimeMapping TIF = new HttpMimeMapping("tif", "image/tiff");

	/** MIMEタイプ(image/tiff) */
	public static final HttpMimeMapping TIFF = new HttpMimeMapping("tiff", "image/tiff");

	/** MIMEタイプ(application/x-troff) */
	public static final HttpMimeMapping TR = new HttpMimeMapping("tr", "application/x-troff");

	/** MIMEタイプ(text/tab-separated-values) */
	public static final HttpMimeMapping TSV = new HttpMimeMapping("tsv", "text/tab-separated-values");

	/** MIMEタイプ(text/plain) */
	public static final HttpMimeMapping TXT = new HttpMimeMapping("txt", "text/plain");

	/** MIMEタイプ(audio/basic) */
	public static final HttpMimeMapping ULW = new HttpMimeMapping("ulw", "audio/basic");

	/** MIMEタイプ(application/x-ustar) */
	public static final HttpMimeMapping USTAR = new HttpMimeMapping("ustar", "application/x-ustar");

	/** MIMEタイプ(image/x-xbitmap) */
	public static final HttpMimeMapping XBM = new HttpMimeMapping("xbm", "image/x-xbitmap");

	/** MIMEタイプ(application/xhtml+xml) */
	public static final HttpMimeMapping XHT = new HttpMimeMapping("xht", "application/xhtml+xml");

	/** MIMEタイプ(application/xhtml+xml) */
	public static final HttpMimeMapping XHTML = new HttpMimeMapping("xhtml", "application/xhtml+xml");

	/** MIMEタイプ(text/xml) */
	public static final HttpMimeMapping XML = new HttpMimeMapping("xml", "text/xml");

	/** MIMEタイプ(image/x-xpixmap) */
	public static final HttpMimeMapping XPM = new HttpMimeMapping("xpm", "image/x-xpixmap");

	/** MIMEタイプ(text/xml) */
	public static final HttpMimeMapping XSL = new HttpMimeMapping("xsl", "text/xml");

	/** MIMEタイプ(image/x-xwindowdump) */
	public static final HttpMimeMapping XWD = new HttpMimeMapping("xwd", "image/x-xwindowdump");

	/** MIMEタイプ(audio/x-wav) */
	public static final HttpMimeMapping WAV = new HttpMimeMapping("wav", "audio/x-wav");

	/** MIMEタイプ(image/svg+xml) */
	public static final HttpMimeMapping SVG = new HttpMimeMapping("svg", "image/svg+xml");

	/** MIMEタイプ(image/svg+xml) */
	public static final HttpMimeMapping SVGZ = new HttpMimeMapping("svgz", "image/svg+xml");

	/** MIMEタイプ(application/x-visio) */
	public static final HttpMimeMapping VSD = new HttpMimeMapping("vsd", "application/x-visio");

	/** MIMEタイプ(image/vnd.wap.wbmp) */
	public static final HttpMimeMapping WBMP = new HttpMimeMapping("wbmp", "image/vnd.wap.wbmp");

	/** MIMEタイプ(text/vnd.wap.wml) */
	public static final HttpMimeMapping WML = new HttpMimeMapping("wml", "text/vnd.wap.wml");

	/** MIMEタイプ(application/vnd.wap.wmlc) */
	public static final HttpMimeMapping WMLC = new HttpMimeMapping("wmlc", "application/vnd.wap.wmlc");

	/** MIMEタイプ(text/vnd.wap.wmlscript) */
	public static final HttpMimeMapping WMLS = new HttpMimeMapping("wmls", "text/vnd.wap.wmlscript");

	/** MIMEタイプ(application/vnd.wap.wmlscriptc) */
	public static final HttpMimeMapping WMLSCRIPTC = new HttpMimeMapping("wmlscriptc", "application/vnd.wap.wmlscriptc");

	/** MIMEタイプ(x-world/x-vrml) */
	public static final HttpMimeMapping WRL = new HttpMimeMapping("wrl", "x-world/x-vrml");

	/** MIMEタイプ(application/x-compress) */
	public static final HttpMimeMapping Z = new HttpMimeMapping("Z", "application/x-compress");

	/** MIMEタイプ(application/zip) */
	public static final HttpMimeMapping ZIP = new HttpMimeMapping("zip", "application/zip");

	/** 全MIMEタイプ配列 */
	private static final HttpMimeMapping[] ALL_MIME_MAPPING = new HttpMimeMapping[] { //
	//
			ABS, //
			AI, //
			AIF, //
			AIFC, //
			AIFF, //
			AIM, //
			ART, //
			ASF, //
			ASX, //
			AU, //
			AVI, //
			AVX, //
			BCPIO, //
			BIN, //
			BMP, //
			BODY, //
			CDF, //
			CER, //
			CLASS, //
			CPIO, //
			CSH, //
			CSS, //
			DIB, //
			DOC, //
			DTD, //
			DV, //
			DVI, //
			EPS, //
			ETX, //
			EXE, //
			GIF, //
			GTAR, //
			GZ, //
			HDF, //
			HQX, //
			HTC, //
			HTM, //
			HTML, //
			IEF, //
			JAD, //
			JAR, //
			JAVA, //
			JNLP, //
			JPE, //
			JPEG, //
			JPG, //
			JS, //
			JSF, //
			JSPF, //
			KAR, //
			LATEX, //
			M3U, //
			MAC, //
			MAN, //
			ME, //
			MID, //
			MIDI, //
			MIF, //
			MOV, //
			MOVIE, //
			MP1, //
			MP2, //
			MP3, //
			MPA, //
			MPE, //
			MPEG, //
			MPEGA, //
			MPG, //
			MPV2, //
			MS, //
			NC, //
			ODA, //
			PBM, //
			PCT, //
			PDF, //
			PGM, //
			PIC, //
			PICT, //
			PLS, //
			PNG, //
			PNM, //
			PNT, //
			PPM, //
			PPT, //
			PS, //
			PSD, //
			QT, //
			QTI, //
			QTIF, //
			RAS, //
			RGB, //
			RM, //
			ROFF, //
			RTF, //
			RTX, //
			SH, //
			SHAR, //
			SMF, //
			SIT, //
			SND, //
			SRC, //
			SV4CPIO, //
			SV4CRC, //
			SWF, //
			T, //
			TAR, //
			TCL, //
			TEX, //
			TEXI, //
			TEXINFO, //
			TIF, //
			TIFF, //
			TR, //
			TSV, //
			TXT, //
			ULW, //
			USTAR, //
			XBM, //
			XHT, //
			XHTML, //
			XML, //
			XPM, //
			XSL, //
			XWD, //
			WAV, //
			SVG, //
			SVGZ, //
			VSD, //
			WBMP, //
			WML, //
			WMLC, //
			WMLS, //
			WMLSCRIPTC, //
			WRL, //
			Z, //
			ZIP, //
	};

	/** 拡張子 */
	private String extension;

	/** MIMEタイプ */
	private String mimeType;

	/**
	 * コンストラクタ<br>
	 */
	private HttpMimeMapping() {
		super();
	}

	/**
	 * コンストラクタ<br>
	 * @param extension 拡張子
	 * @param mimeType MIMEタイプ
	 */
	public HttpMimeMapping(String extension, String mimeType) {
		super();
		this.extension = extension;
		this.mimeType = mimeType;
	}

	/**
	 * 拡張子を取得します。<br>
	 * @return 拡張子
	 */
	public String getExtension() {
		return extension;
	}

	/**
	 * MIMEタイプを取得します。<br>
	 * @return MIMEタイプ
	 */
	public String getMimeType() {
		return mimeType;
	}

	/**
	 * 指定された拡張子のMIMEマッピングオブジェクトを取得します。<br>
	 * 指定された拡張子に対応するステータスオブジェクトが存在しない場合は
	 * 一時的に作成される指定された拡張子を保持したMIMEオブジェクトが返却されます。<br>
	 * 尚、拡張子の大文字小文字の区別は行われません。<br>
	 * @param extension 拡張子
	 * @return MIMEマッピングオブジェクト
	 */
	public static HttpMimeMapping getMapping(String extension) {
		for (int i = 0; i <= ALL_MIME_MAPPING.length - 1; i++) {
			HttpMimeMapping mapping = ALL_MIME_MAPPING[i];
			if (mapping.getExtension().equalsIgnoreCase(extension)) {
				return mapping;
			}
		}
		return new HttpMimeMapping(extension, "application/" + extension);
	}

	/**
	 * オブジェクトのハッシュコード値を返します。<br>
	 * @return オブジェクトのハッシュコード値
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		//result = PRIME * result + ((extension == null) ? 0 : extension.hashCode());
		result = PRIME * result + ((extension == null) ? 0 : extension.toLowerCase().hashCode());
		result = PRIME * result + ((mimeType == null) ? 0 : mimeType.hashCode());
		return result;
	}

	/**
	 * このオブジェクトと他のオブジェクトが等しいかどうかを示します。<br>
	 * @param object 比較対象オブジェクト
	 * @return オブジェクト同士が等価である場合にtrueを返却
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}
		if (object == null) {
			return false;
		}
		if (getClass() != object.getClass()) {
			return false;
		}
		final HttpMimeMapping other = (HttpMimeMapping) object;
		if (extension == null) {
			if (other.extension != null) {
				return false;
			}
			//} else if (!extension.equals(other.extension)) {
		} else if (!extension.equalsIgnoreCase(other.extension)) {
			return false;
		}
		if (mimeType == null) {
			if (other.mimeType != null) {
				return false;
			}
		} else if (!mimeType.equals(other.mimeType)) {
			return false;
		}
		return true;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("extension=");
		buffer.append(extension);
		buffer.append(",");
		buffer.append("mimeType=");
		buffer.append(mimeType);
		buffer.append("}");
		return buffer.toString();
	}
}
