package org.phosphoresce.commons.mail;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

import org.phosphoresce.commons.mail.exception.MailAddressException;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

/**
 * MAMAhXێNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 * 2007/02/26	Kitagawa		̑MAhX̕`擾\bhǉ
 * 2007/02/27	Kitagawa		InternetAddressNXɂp[XpAhXǉ\bhǉ
 * 2007/03/01	Kitagawa		ԐMAhX̕ێdlǉ
 * 2007/03/07	Kitagawa		AhX̂ɑ΂LN^ZbgwC^tF[Xǉ
 *-->
 */
public final class MailAddressContainer implements Serializable, MailDeclareInterface {

	/** MAhXXg */
	private List fromList = new LinkedList();

	/** ԐMAhXXg */
	private List replyList = new LinkedList();

	/** M(TO)AhXXg */
	private List recipientTOList = new LinkedList();

	/** M(CC)AhXXg */
	private List recipientCCList = new LinkedList();

	/** M(BCC)AhXXg */
	private List recipientBCCList = new LinkedList();

	/**
	 * RXgN^<br>
	 */
	public MailAddressContainer() {
		super();
	}

	/**
	 * w肳ꂽXgɃAhXǉ܂B<br>
	 * AAAhXIuWFNgnull̏ꍇ͒ǉ܂B<br>
	 * @param list ǉΏۃXg
	 * @param address ǉAhX
	 */
	private void add(List list, Address address) {
		if (address != null) {
			list.add(address);
		}
	}

	/**
	 * w肳ꂽXgɃAhXǉ܂B<br>
	 * AAAhXIuWFNgnull̏ꍇ͒ǉ܂B<br>
	 * @param list ǉΏۃXg
	 * @param address ǉAhX
	 */
	private void add(List list, Address[] address) {
		if (address != null) {
			list.addAll(Arrays.asList(address));
		}
	}

	/**
	 * w肳ꂽXgɃAhXǉ܂B<br>
	 * AAAhXȈꍇ͒ǉ܂B<br>
	 * @param list ǉΏۃXg
	 * @param address ǉAhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	private void add(List list, String address, String charset) throws MailAddressException {
		try {
			if (!StringUtil.isEmpty(address)) {
				InternetAddress[] iAddresses = InternetAddress.parse(address);
				for (int i = 0; i <= iAddresses.length - 1; i++) {
					String personal = iAddresses[i].getPersonal();
					String mailaddress = iAddresses[i].getAddress();
					if (personal != null) {
						iAddresses[i].setPersonal(MimeUtility.encodeText(personal, charset, null));
					}
				}
				add(list, iAddresses);
			}
		} catch (AddressException e) {
			throw new MailAddressException("[AhX̃p[XɎs܂", e);
		} catch (UnsupportedEncodingException e) {
			throw new MailAddressException("[AhX̃p[XɎs܂", e);
		}
	}

	/**
	 * w肳ꂽXgێAhX擾܂B<br>
	 * @return AhX
	 */
	private int getNumberOf(List list) {
		return list.size();
	}

	/**
	 * w肳ꂽXg̃Ce[^IuWFNg擾܂B<br>
	 * @return Ce[^IuWFNg
	 */
	private Iterator iterator(List list) {
		return list.iterator();
	}

	/**
	 * w肳ꂽXgێAhXS𕶎ƂĎ擾܂B<br>
	 * @param list AhXێ郊XgIuWFNg
	 * @return AhX
	 * @throws MailAddressException ɃAhX̎擾sȂꍇɔ
	 */
	private String getAddressesValue(List list) throws MailAddressException {
		try {
			Address[] addresses = (Address[]) list.toArray(new Address[list.size()]);
			return MailUtil.createMailAddressValue(addresses);
		} catch (Exception e) {
			throw new MailAddressException("AhX̎擾ɗ\ʗO܂", e);
		}
	}

	/**
	 * w肳ꂽXgێAhXSzƂĎ擾܂B<br>
	 * @param list 擾ΏۃAhXXg
	 * @return AhXIuWFNgz
	 */
	private Address[] getAddresses(List list) {
		return (Address[]) list.toArray(new Address[list.size()]);
	}

	/**
	 * MAhXǉ܂B<br>
	 * @param address MAhX
	 */
	public void addFrom(Address address) {
		add(fromList, address);
	}

	/**
	 * ԐMAhXǉ܂B<br>
	 * @param address ԐMAhX
	 */
	public void addReply(Address address) {
		add(replyList, address);
	}

	/**
	 * M(TO)AhXǉ܂B<br>
	 * @param address M(TO)AhX
	 */
	public void addRecipientTo(Address address) {
		add(recipientTOList, address);
	}

	/**
	 * M(CC)AhXǉ܂B<br>
	 * @param address M(CC)AhX
	 */
	public void addRecipientCc(Address address) {
		add(recipientCCList, address);
	}

	/**
	 * M(BCC)AhXǉ܂B<br>
	 * @param address M(BCC)AhX
	 */
	public void addRecipientBcc(Address address) {
		add(recipientBCCList, address);
	}

	/**
	 * MAhXǉ܂B<br>
	 * @param address MAhX
	 */
	public void addFrom(Address[] address) {
		add(fromList, address);
	}

	/**
	 * ԐMAhXǉ܂B<br>
	 * @param address ԐMAhX
	 */
	public void addReply(Address[] address) {
		add(replyList, address);
	}

	/**
	 * M(TO)AhXǉ܂B<br>
	 * @param address M(TO)AhX
	 */
	public void addRecipientTo(Address[] address) {
		add(recipientTOList, address);
	}

	/**
	 * M(CC)AhXǉ܂B<br>
	 * @param address M(CC)AhX
	 */
	public void addRecipientCc(Address[] address) {
		add(recipientCCList, address);
	}

	/**
	 * M(BCC)AhXǉ܂B<br>
	 * @param address M(BCC)AhX
	 */
	public void addRecipientBcc(Address[] address) {
		add(recipientBCCList, address);
	}

	/**
	 * MAhXǉ܂B<br>
	 * @param address MAhX
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addFrom(String address) throws MailAddressException {
		add(fromList, address, null);
	}

	/**
	 * ԐMAhXǉ܂B<br>
	 * @param address ԐMAhX
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addReply(String address) throws MailAddressException {
		add(replyList, address, null);
	}

	/**
	 * M(TO)AhXǉ܂B<br>
	 * @param address M(TO)AhX
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientTo(String address) throws MailAddressException {
		add(recipientTOList, address, null);
	}

	/**
	 * M(CC)AhXǉ܂B<br>
	 * @param address M(CC)AhX
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientCc(String address) throws MailAddressException {
		add(recipientCCList, address, null);
	}

	/**
	 * M(BCC)AhXǉ܂B<br>
	 * @param address M(BCC)AhX
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientBcc(String address) throws MailAddressException {
		add(recipientBCCList, address, null);
	}

	/**
	 * MAhXǉ܂B<br>
	 * @param address MAhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addFrom(String address, String charset) throws MailAddressException {
		add(fromList, address, charset);
	}

	/**
	 * ԐMAhXǉ܂B<br>
	 * @param address ԐMAhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addReply(String address, String charset) throws MailAddressException {
		add(replyList, address, charset);
	}

	/**
	 * M(TO)AhXǉ܂B<br>
	 * @param address M(TO)AhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientTo(String address, String charset) throws MailAddressException {
		add(recipientTOList, address, charset);
	}

	/**
	 * M(CC)AhXǉ܂B<br>
	 * @param address M(CC)AhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientCc(String address, String charset) throws MailAddressException {
		add(recipientCCList, address, charset);
	}

	/**
	 * M(BCC)AhXǉ܂B<br>
	 * @param address M(BCC)AhX
	 * @param charset MIMELN^Zbg
	 * @throws MailAddressException w肳ꂽAhX̃p[XɎsꍇɔ
	 */
	public void addRecipientBcc(String address, String charset) throws MailAddressException {
		add(recipientBCCList, address, charset);
	}

	/**
	 * MAhX擾܂B<br>
	 * @return MAhX
	 */
	public int getNumberOfFrom() {
		return getNumberOf(fromList);
	}

	/**
	 * ԐMAhX擾܂B<br>
	 * @return ԐMAhX
	 */
	public int getNumberOfReply() {
		return getNumberOf(replyList);
	}

	/**
	 * M(TO)AhX擾܂B<br>
	 * @return M(TO)AhX
	 */
	public int getNumberOfRecipientTo() {
		return getNumberOf(recipientTOList);
	}

	/**
	 * M(CC)AhX擾܂B<br>
	 * @return M(CC)AhX
	 */
	public int getNumberOfRecipientCc() {
		return getNumberOf(recipientCCList);
	}

	/**
	 * M(BCC)AhX擾܂B<br>
	 * @return M(BCC)AhX
	 */
	public int getNumberOfRecipientBcc() {
		return getNumberOf(recipientBCCList);
	}

	/**
	 * MAhXCe[^IuWFNg擾܂B<br>
	 * @return MAhXCe[^IuWFNg
	 */
	public Iterator fromIterator() {
		return iterator(fromList);
	}

	/**
	 * ԐMAhXCe[^IuWFNg擾܂B<br>
	 * @return ԐMAhXCe[^IuWFNg
	 */
	public Iterator replyIterator() {
		return iterator(replyList);
	}

	/**
	 * M(TO)AhXCe[^IuWFNg擾܂B<br>
	 * @return M(TO)AhXCe[^IuWFNg
	 */
	public Iterator recipientToIterator() {
		return iterator(recipientTOList);
	}

	/**
	 * M(CC)AhXCe[^IuWFNg擾܂B<br>
	 * @return M(CC)AhXCe[^IuWFNg
	 */
	public Iterator recipientCcIterator() {
		return iterator(recipientCCList);
	}

	/**
	 * M(BCC)AhXCe[^IuWFNg擾܂B<br>
	 * @return M(BCC)AhXCe[^IuWFNg
	 */
	public Iterator recipientBccIterator() {
		return iterator(recipientBCCList);
	}

	/**
	 * MAhXSZ~R؂Ŏ擾܂B<br>
	 * @return MAhXS
	 * @throws MailAddressException ɑMAhX擾łȂꍇɔ
	 */
	public String getFromAddressesValue() throws MailAddressException {
		return getAddressesValue(fromList);
	}

	/**
	 * ԐMAhXSZ~R؂Ŏ擾܂B<br>
	 * @return ԐMAhXS
	 * @throws MailAddressException ɕԐMAhX擾łȂꍇɔ
	 */
	public String getReplyAddressesValue() throws MailAddressException {
		return getAddressesValue(replyList);
	}

	/**
	 * M(TO)AhXSZ~R؂Ŏ擾܂B<br>
	 * @return M(TO)AhXS
	 * @throws MailAddressException ɑMAhX擾łȂꍇɔ
	 */
	public String getRecipientToAddressesValue() throws MailAddressException {
		return getAddressesValue(recipientTOList);
	}

	/**
	 * M(CC)AhXSZ~R؂Ŏ擾܂B<br>
	 * @return M(CC)AhXS
	 * @throws MailAddressException ɑMAhX擾łȂꍇɔ
	 */
	public String getRecipientCcAddressesValue() throws MailAddressException {
		return getAddressesValue(recipientCCList);
	}

	/**
	 * M(BCC)AhXSZ~R؂Ŏ擾܂B<br>
	 * @return M(BCC)AhXS
	 * @throws MailAddressException ɑMAhX擾łȂꍇɔ
	 */
	public String getRecipientBccAddressesValue() throws MailAddressException {
		return getAddressesValue(recipientBCCList);
	}

	/**
	 * MAhXSzƂĎ擾܂B<br>
	 * @return AhXIuWFNgz
	 */
	public Address[] getFromAddresses() {
		return getAddresses(fromList);
	}

	/**
	 * ԐMAhXSzƂĎ擾܂B<br>
	 * @return AhXIuWFNgz
	 */
	public Address[] getReplyAddresses() {
		return getAddresses(replyList);
	}

	/**
	 * M(TO)AhXSzƂĎ擾܂B<br>
	 * @return AhXIuWFNgz
	 */
	public Address[] getRecipientToAddresses() {
		return getAddresses(recipientTOList);
	}

	/**
	 * M(CC)AhXSzƂĎ擾܂B<br>
	 * @return AhXIuWFNgz
	 */
	public Address[] getRecipientCcAddresses() {
		return getAddresses(recipientCCList);
	}

	/**
	 * M(BCC)AhXSzƂĎ擾܂B<br>
	 * @return AhXIuWFNgz
	 */
	public Address[] getRecipientBccAddresses() {
		return getAddresses(recipientBCCList);
	}
}
