package org.phosphoresce.commons.logging.test;

import java.awt.Dimension;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.phosphoresce.commons.eswing.EFrame;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.core.ESwingConfigManager;
import org.phosphoresce.commons.logging.appender.TextPaneAppender;
import org.phosphoresce.commons.logging.config.LoggingColorSet;

/**
 * eXgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public class TestTextPaneAppender {

	/** K[IuWFNg */
	private static final Log log = LogFactory.getLog(TestTextPaneAppender.class);

	/**
	 * C\bh<br>
	 * @param args R}hC
	 */
	public static void main(String[] args) {
		ESwingConfigManager.configure();

		DOMConfigurator.configure(TestTextPaneAppender.class.getResource("/org/phosphoresce/commons/logging/test/TestTextPaneAppender-log4j.xml"));

		TextPaneAppender appender = TextPaneAppender.getAppender("test");
		appender.setColorSet(new LoggingColorSet());

		EScrollPane scrollPane = new EScrollPane();
		scrollPane.setPreferredSize(new Dimension(800, 400));
		scrollPane.setMaximumSize(new Dimension(800, 400));
		scrollPane.setMinimumSize(new Dimension(800, 400));
		scrollPane.setViewportView(appender.getLoggingTarget());
		scrollPane.setAutoscrolls(true);

		EFrame frame = new EFrame();
		frame.setContentPane(scrollPane);
		frame.setTitle("TextPaneAppender Test");
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);

		log.fatal("fatal message.", new Exception("test throwable"));
		log.error("error message.", new Exception("test throwable"));
		log.warn("warning message.", new Exception("test throwable"));
		log.info("information message.", new Exception("test throwable"));
		log.debug("debug message.", new Exception("test throwable"));
		log.trace("trace message.", new Exception("test throwable"));

		for (int i = 0; i <= 49; i++) {
			log.debug("logging " + i);
		}
	}
}
