package org.phosphoresce.commons.logging.config;

import java.awt.Color;
import java.io.Serializable;

/**
 * MÕJ[ZbgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/27	Kitagawa		VK쐬
 *-->
 */
public final class LoggingColorSet implements Serializable {

	/** vIObZ[WJ[ */
	public static final Color DEFAULT_FATAL_COLOR = Color.decode("#ff0000");

	/** G[bZ[WJ[ */
	public static final Color DEFAULT_ERROR_COLOR = Color.decode("#ff7711");

	/** xbZ[WJ[ */
	public static final Color DEFAULT_WARN_COLOR = Color.decode("#ff7711");

	/** 񃁃bZ[WJ[ */
	public static final Color DEFAULT_INFO_COLOR = Color.decode("#000000");

	/** fobObZ[WJ[ */
	public static final Color DEFAULT_DEBUG_COLOR = Color.decode("#888888");

	/** g[XbZ[WJ[ */
	public static final Color DEFAULT_TRACE_COLOR = Color.decode("#888888");

	/** vIObZ[WJ[ */
	private Color fatalColor = null;

	/** G[bZ[WJ[ */
	private Color errorColor = null;

	/** xbZ[WJ[ */
	private Color warnColor = null;

	/** 񃁃bZ[WJ[ */
	private Color infoColor = null;

	/** fobObZ[WJ[ */
	private Color debugColor = null;

	/** g[XbZ[WJ[ */
	private Color traceColor = null;

	/**
	 * RXgN^<br>
	 * @param fatalColor vIObZ[WJ[
	 * @param errorColor G[bZ[WJ[
	 * @param warnColor xbZ[WJ[
	 * @param infoColor 񃁃bZ[WJ[
	 * @param debugColor fobObZ[WJ[
	 * @param traceColor g[XbZ[WJ[
	 */
	public LoggingColorSet(Color fatalColor, Color errorColor, Color warnColor, Color infoColor, Color debugColor, Color traceColor) {
		super();
		this.fatalColor = fatalColor;
		this.errorColor = errorColor;
		this.warnColor = warnColor;
		this.infoColor = infoColor;
		this.debugColor = debugColor;
		this.traceColor = traceColor;
	}

	/**
	 * RXgN^<br>
	 * @param fatalColor vIObZ[WJ[
	 * @param errorColor G[bZ[WJ[
	 * @param warnColor xbZ[WJ[
	 * @param infoColor 񃁃bZ[WJ[
	 * @param debugColor fobObZ[WJ[
	 */
	public LoggingColorSet(Color fatalColor, Color errorColor, Color warnColor, Color infoColor, Color debugColor) {
		this(fatalColor, errorColor, warnColor, infoColor, debugColor, DEFAULT_TRACE_COLOR);
	}

	/**
	 * RXgN^<br>
	 */
	public LoggingColorSet() {
		this(DEFAULT_FATAL_COLOR, DEFAULT_ERROR_COLOR, DEFAULT_WARN_COLOR, DEFAULT_INFO_COLOR, DEFAULT_DEBUG_COLOR, DEFAULT_TRACE_COLOR);
	}

	/**
	 * vIObZ[WJ[擾܂B<br>
	 * @return vIObZ[WJ[
	 */
	public Color getFatalColor() {
		return fatalColor;
	}

	/**
	 * vIObZ[WJ[ݒ肵܂B<br>
	 * @param fatalColor vIObZ[WJ[
	 */
	public void setFatalColor(Color fatalColor) {
		this.fatalColor = fatalColor;
	}

	/**
	 * G[bZ[WJ[擾܂B<br>
	 * @return G[bZ[WJ[
	 */
	public Color getErrorColor() {
		return errorColor;
	}

	/**
	 * G[bZ[WJ[ݒ肵܂B<br>
	 * @param errorColor G[bZ[WJ[
	 */
	public void setErrorColor(Color errorColor) {
		this.errorColor = errorColor;
	}

	/**
	 * xbZ[WJ[擾܂B<br>
	 * @return xbZ[WJ[
	 */
	public Color getWarnColor() {
		return warnColor;
	}

	/**
	 * xbZ[WJ[ݒ肵܂B<br>
	 * @param warnColor xbZ[WJ[
	 */
	public void setWarnColor(Color warnColor) {
		this.warnColor = warnColor;
	}

	/**
	 * 񃁃bZ[WJ[擾܂B<br>
	 * @return 񃁃bZ[WJ[
	 */
	public Color getInfoColor() {
		return infoColor;
	}

	/**
	 * 񃁃bZ[WJ[ݒ肵܂B<br>
	 * @param infoColor 񃁃bZ[WJ[
	 */
	public void setInfoColor(Color infoColor) {
		this.infoColor = infoColor;
	}

	/**
	 * fobObZ[WJ[擾܂B<br>
	 * @return fobObZ[WJ[
	 */
	public Color getDebugColor() {
		return debugColor;
	}

	/**
	 * fobObZ[WJ[ݒ肵܂B<br>
	 * @param debugColor fobObZ[WJ[
	 */
	public void setDebugColor(Color debugColor) {
		this.debugColor = debugColor;
	}

	/**
	 * g[XbZ[WJ[擾܂B<br>
	 * @return g[XbZ[WJ[
	 */
	public Color getTraceColor() {
		return traceColor;
	}

	/**
	 * g[XbZ[WJ[ݒ肵܂B<br>
	 * @param traceColor g[XbZ[WJ[
	 */
	public void setTraceColor(Color traceColor) {
		this.traceColor = traceColor;
	}
}
