package org.phosphoresce.common.graphics.test;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

import javax.swing.JComponent;

/**
 * イメージ描画テストパネル<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/09	Kitagawa		新規作成
 *-->
 */
public class ImageTestPanel extends JComponent {

	/** イメージオブジェクト */
	private Image image = null;

	/** ストレッチフラグ */
	private boolean strech = false;

	/**
	 * コンストラクタ<br>
	 */
	public ImageTestPanel() {
		super();
		initialize();
	}

	/**
	 * コンポーネントを初期化します。<br>
	 */
	private void initialize() {
		this.setOpaque(false);
		this.setDoubleBuffered(true);
	}

	/**
	 * イメージオブジェクトを取得します。<br>
	 * @return イメージオブジェクト
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * イメージオブジェクトを設定します。<br>
	 * @param image イメージオブジェクト
	 */
	public void setImage(Image image) {
		this.image = image;
	}

	/**
	 * ストレッチフラグを取得します。<br>
	 * @return ストレッチフラグ
	 */
	public boolean isStrech() {
		return strech;
	}

	/**
	 * ストレッチフラグを設定します。<br>
	 * @param strech ストレッチフラグ
	 */
	public void setStrech(boolean strech) {
		this.strech = strech;
	}

	/**
	 * コンポーネントを描画します。<br>
	 * @param graphics グラフィックスオブジェクト
	 * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
	 */
	protected void paintComponent(Graphics graphics) {
		//super.paintComponent(graphics);
		paintImage((Graphics2D) graphics);
	}

	/**
	 * イメージを描画します。<br>
	 * @param graphics グラフィックスオブジェクト
	 */
	protected void paintImage(Graphics2D graphics) {
		if (getImage() != null) {
			graphics.drawImage(getImage(), 0, 0, this);
		}
	}
}
