package org.phosphoresce.common.graphics.paint;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

/**
 * 円形グラデーションペイントクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/08	Kitagawa		新規作成
 *-->
 */
public class RadialGradientPaint extends AbstractGradientPaint {

	/** ストレッチフラグ */
	private boolean strech = false;

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param alphaDefine グラデーションアルファ定義
	 * @param smoothness 滑らかさ(0.0f～1.0f)
	 * @param ratio 比率(0.0f～100.0f)
	 * @param strech ストレッチフラグ
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, GradientAlphaDefine alphaDefine, float smoothness, float ratio, boolean strech) {
		super(colorDefine, alphaDefine, DEFAULT_ANGLE, smoothness, ratio);
		this.strech = strech;
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param alphaDefine グラデーションアルファ定義
	 * @param strech ストレッチフラグ
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, GradientAlphaDefine alphaDefine, boolean strech) {
		this(colorDefine, alphaDefine, DEFAULT_SMOOTHNESS, DEFAULT_RAITO, strech);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param alphaDefine グラデーションアルファ定義
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, GradientAlphaDefine alphaDefine) {
		this(colorDefine, alphaDefine, DEFAULT_SMOOTHNESS, DEFAULT_RAITO, false);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param smoothness 滑らかさ(0.0f～1.0f)
	 * @param ratio 比率(0.0f～100.0f)
	 * @param strech ストレッチフラグ
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, float smoothness, float ratio, boolean strech) {
		this(colorDefine, null, smoothness, ratio, strech);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param smoothness 滑らかさ(0.0f～1.0f)
	 * @param ratio 比率(0.0f～100.0f)
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, float smoothness, float ratio) {
		this(colorDefine, null, smoothness, ratio, false);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 * @param strech ストレッチフラグ
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine, boolean strech) {
		this(colorDefine, null, DEFAULT_SMOOTHNESS, DEFAULT_RAITO, strech);
	}

	/**
	 * コンストラクタ<br>
	 * @param colorDefine グラデーションカラー定義
	 */
	public RadialGradientPaint(GradientColorDefine colorDefine) {
		this(colorDefine, null, DEFAULT_SMOOTHNESS, DEFAULT_RAITO, false);
	}

	/**
	 * カラーパターンを生成するために使用するPaintContextを生成します。<br>
	 * @param model Paintデータを受け取るColorModelオブジェクト
	 * @param deviceBounds 描画されるグラフィックスプリミティブのデバイス空間でのバウンディングボックス
	 * @param userBounds 描画されるグラフィックスプリミティブのユーザ空間でのバウンディングボックス
	 * @param transform ユーザ空間からデバイス空間へのAffineTransform
	 * @param hints コンテキストオブジェクトが描画の選択肢を選択するときに使用するヒント
	 * @return PaintContextオブジェクト
	 * @see java.awt.Paint#createContext(java.awt.image.ColorModel, java.awt.Rectangle, java.awt.geom.Rectangle2D, java.awt.geom.AffineTransform, java.awt.RenderingHints)
	 */
	public PaintContext createContext(ColorModel model, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
		return new RadialGradientPaintContext(model, deviceBounds, userBounds, transform, hints, getColorDefine(), getAlphaDefine(), getSmoothness(), getRatio(), strech);
	}
}
