package org.phosphoresce.common.graphics.paint;

import java.awt.Color;
import java.util.List;

/**
 * グラデーションアルファ定義クラス<br>
 * <br>
 * 当クラスは自身のグラデーション定義及び、リレーション情報を管理します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/08	Kitagawa		新規作成
 *-->
 */
public class GradientAlphaDefine extends GradientDefine {

	/** カラー */
	private float alpha;

	/**
	 * コンストラクタ<br>
	 * @param alpha 透明度
	 * @param location 位置
	 * @param behindDivergence 後方分岐ポイント
	 * @param frontDivergence 前方分岐ポイント
	 */
	public GradientAlphaDefine(float alpha, float location, float behindDivergence, float frontDivergence) {
		super(location, behindDivergence, frontDivergence);
		this.setAlpha(alpha);
	}

	/**
	 * コンストラクタ<br>
	 * @param alpha 透明度
	 * @param location 位置
	 */
	public GradientAlphaDefine(float alpha, float location) {
		this(alpha, location, 0.5f, 0.5f);
	}

	/**
	 * コンストラクタ<br>
	 */
	private GradientAlphaDefine() {
		this(1.0f, 0.0f, 0.5f, 0.5f);
	}

	/**
	 * グラデーション定義が提供するカラーを取得します。<br>
	 * @return グラデーション定義が提供するカラー
	 * @see org.phosphoresce.common.graphics.paint.GradientDefine#getGradientColor()
	 */
	public Color getGradientColor() {
		return new Color(0.0f, 1.0f, 0.0f, alpha);
	}

	/**
	 * 全てのグラデーションカラー定義を取得します。<br>
	 * @return 全てのグラデーションカラー定義
	 * @see org.phosphoresce.common.graphics.paint.GradientDefine#getAllDefines()
	 */
	public GradientDefine[] getAllDefines() {
		List list = getAllDefineList();
		return (GradientAlphaDefine[]) list.toArray(new GradientAlphaDefine[list.size()]);
	}

	/**
	 * 透明度を取得します。<br>
	 * @return 透明度
	 */
	public float getAlpha() {
		return alpha;
	}

	/**
	 * 透明度を設定します。<br>
	 * @param alpha 透明度
	 */
	public void setAlpha(float alpha) {
		this.alpha = alpha;
		if (this.alpha > 1.0f) {
			this.alpha = 1.0f;
		} else if (this.alpha < 0.0f) {
			this.alpha = 0.0f;
		}
	}

	/**
	 * ディフォルトグラデーション透明度定義を生成します。<br>
	 * @return ディフォルトグラデーション透明度定義
	 */
	public static GradientAlphaDefine createDefaultGradientAlphaDefine() {
		GradientAlphaDefine point1 = new GradientAlphaDefine();
		GradientAlphaDefine point2 = new GradientAlphaDefine();
		point1.alpha = 1.0f;
		point1.location = 0.0f;
		point2.alpha = 1.0f;
		point2.location = 1.0f;
		point1.add(point2);
		return point1;
	}
}
