package org.phosphoresce.common.graphics.paint;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

/**
 * ペイント上位抽象クラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/06/08	Kitagawa		新規作成
 *-->
 */
public abstract class AbstractPaint implements Paint {

	/** ディフォルト角度 */
	public static final double DEFAULT_ANGLE = 0.0f;

	/** 角度 */
	private double angle = DEFAULT_ANGLE;

	/**
	 * コンストラクタ<br>
	 * @param angle 角度
	 */
	public AbstractPaint(double angle) {
		super();
		this.angle = angle;
	}

	/**
	 * コンストラクタ<br>
	 */
	public AbstractPaint() {
		this(0);
	}

	/**
	 * ペイントオブジェクトのTransparencyを取得します。<br>
	 * @return ペイントオブジェクトのTransparency
	 * @see java.awt.Transparency#getTransparency()
	 */
	public abstract int getTransparency();

	/**
	 * カラーパターンを生成するために使用するPaintContextを生成します。<br>
	 * @param model Paintデータを受け取るColorModelオブジェクト
	 * @param deviceBounds 描画されるグラフィックスプリミティブのデバイス空間でのバウンディングボックス
	 * @param userBounds 描画されるグラフィックスプリミティブのユーザ空間でのバウンディングボックス
	 * @param transform ユーザ空間からデバイス空間へのAffineTransform
	 * @param hints コンテキストオブジェクトが描画の選択肢を選択するときに使用するヒント
	 * @return PaintContextオブジェクト
	 * @see java.awt.Paint#createContext(java.awt.image.ColorModel, java.awt.Rectangle, java.awt.geom.Rectangle2D, java.awt.geom.AffineTransform, java.awt.RenderingHints)
	 */
	public abstract PaintContext createContext(ColorModel model, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints);

	/**
	 * 角度を取得します。<br>
	 * @return 角度
	 */
	public final double getAngle() {
		return angle;
	}

	/**
	 * 角度を設定します。<br>
	 * @param angle 角度
	 */
	public final void setAngle(double angle) {
		this.angle = angle;
		while (this.angle < 0.0f) {
			this.angle += 360.0f;
		}
		while (this.angle > 360.0f) {
			this.angle -= 360.0f;
		}
	}
}
