package org.phosphoresce.commons.database.test;

import org.phosphoresce.commons.database.accessor.RecordAccessor;
import org.phosphoresce.commons.database.accessor.RecordBufferedAccessor;
import org.phosphoresce.commons.database.core.DatabaseConfig;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;

/**
 * eXgNX<br>
 * eXgpf[^x[Xe[u쐬܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/09	Kitagawa		VK쐬
 *-->
 */
public class TestCreateDatabase implements TestInterface {

	/**
	 * C\bh<br>
	 * @param args R}hC
	 * @throws ɗ\ʗOꍇɃX[܂
	 */
	public static void main(String[] args) throws Exception {
		System.out.println("start...");

		DatabaseConfig config = new DatabaseConfig(JDBC_DRIVER, JDBC_URL, JDBC_USER, JDBC_PASSWORD);
		DatabaseSession session = new DatabaseSession(config);

		try {
			//createTestHSQLTable(session);
			//createTestSQLiteTable(session);
			createTestMySQLTable(session);
			//createTestPostgreSQLTable(session);

			DatabaseQueryManager manager = new DatabaseQueryManager(session, "select * from test");
			manager.execute();
			RecordAccessor accessor = new RecordBufferedAccessor(manager.getResultSet());
			System.out.println(accessor.getResultRowDefinition());
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			session.commit();
			session.close();
		}

		System.out.println("finished...");
	}

	/**
	 * eXgpe[u𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @param createQuery CreateNG
	 * @throws Exception ɗ\ʗOꍇɃX[܂
	 */
	private static void createTestTable(DatabaseSession session, String createQuery) throws Exception {
		DatabaseQueryManager manager = new DatabaseQueryManager(session);

		// drop table
		try {
			manager.setQuery("drop table test");
			manager.execute();
		} catch (Exception e) {
			session.rollback();
			e.printStackTrace();
		}

		// create table
		try {
			manager.setQuery(createQuery);
			manager.execute();
		} catch (Exception e) {
			session.rollback();
			e.printStackTrace();
		}
	}

	/**
	 * eXgpe[u𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @throws Exception ɗ\ʗOꍇɃX[܂
	 */
	private static void createTestHSQLTable(DatabaseSession session) throws Exception {
		StringBuffer buffer = new StringBuffer();
		buffer.append("create table test ( \n");
		buffer.append("id integer PRIMARY KEY, \n");
		buffer.append("general_text varchar(50), \n");
		buffer.append("general_number integer, \n");
		buffer.append("general_timestamp timestamp, \n");
		buffer.append("c_tinyint tinyint, \n");
		buffer.append("c_bigint bigint, \n");
		buffer.append("c_longvarbinary longvarbinary, \n");
		buffer.append("c_varbinary varbinary, \n");
		buffer.append("c_binary binary, \n");
		buffer.append("c_longvarchar longvarchar, \n");
		buffer.append("c_char char, \n");
		buffer.append("c_numeric numeric, \n");
		buffer.append("c_decimal decimal, \n");
		buffer.append("c_integer integer, \n");
		buffer.append("c_smallint smallint, \n");
		buffer.append("c_float float, \n");
		buffer.append("c_real real, \n");
		buffer.append("c_double double, \n");
		buffer.append("c_varchar varchar, \n");
		buffer.append("c_varchar_ignorecase varchar_ignorecase, \n");
		buffer.append("c_boolean boolean, \n");
		buffer.append("c_date date, \n");
		buffer.append("c_time time, \n");
		buffer.append("c_timestamp timestamp, \n");
		buffer.append("c_other other \n");
		buffer.append(" ) ");
		createTestTable(session, buffer.toString());
	}

	/**
	 * eXgpe[u𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @throws Exception ɗ\ʗOꍇɃX[܂
	 */
	private static void createTestSQLiteTable(DatabaseSession session) throws Exception {
		StringBuffer buffer = new StringBuffer();
		buffer.append("create table test ( \n");
		buffer.append("id integer PRIMARY KEY, \n");
		buffer.append("general_text text, \n");
		buffer.append("general_number integer, \n");
		buffer.append("general_timestamp text, \n");
		buffer.append("c_blob blob, \n");
		buffer.append("c_integer integer, \n");
		buffer.append("c_null null, \n");
		buffer.append("c_real real, \n");
		buffer.append("c_text text \n");
		buffer.append(" ) ");
		createTestTable(session, buffer.toString());
	}

	/**
	 * eXgpe[u𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @throws Exception ɗ\ʗOꍇɃX[܂
	 */
	private static void createTestMySQLTable(DatabaseSession session) throws Exception {
		final String table = "test_mysql";
		StringBuffer buffer = new StringBuffer();
		buffer.append("create table test ( \n");
		buffer.append("id integer, \n");
		buffer.append("general_text varchar(50), \n");
		buffer.append("general_number integer, \n");
		buffer.append("general_timestamp timestamp, \n");
		buffer.append("c_bit bit, \n");
		buffer.append("c_bool bool, \n");
		buffer.append("c_tinyint tinyint, \n");
		buffer.append("c_bigint bigint, \n");
		//buffer.append("c_long varbinary long varbinary, \n");
		buffer.append("c_mediumblob mediumblob, \n");
		buffer.append("c_longblob longblob, \n");
		buffer.append("c_blob blob, \n");
		buffer.append("c_tinyblob tinyblob, \n");
		//buffer.append("c_varbinary varbinary, \n");
		//buffer.append("c_binary binary, \n");
		//buffer.append("c_long varchar long varchar, \n");
		buffer.append("c_mediumtext mediumtext, \n");
		buffer.append("c_longtext longtext, \n");
		buffer.append("c_text text, \n");
		buffer.append("c_tinytext tinytext, \n");
		buffer.append("c_char char, \n");
		buffer.append("c_numeric numeric, \n");
		buffer.append("c_decimal decimal, \n");
		buffer.append("c_integer integer, \n");
		buffer.append("c_int int, \n");
		buffer.append("c_mediumint mediumint, \n");
		buffer.append("c_smallint smallint, \n");
		buffer.append("c_float float, \n");
		buffer.append("c_double double, \n");
		//buffer.append("c_double precision double precision, \n");
		buffer.append("c_real real, \n");
		buffer.append("c_varchar varchar(100), \n");
		//buffer.append("c_enum enum, \n");
		//buffer.append("c_set set, \n");
		buffer.append("c_date date, \n");
		buffer.append("c_time time, \n");
		buffer.append("c_datetime datetime, \n");
		buffer.append("c_timestamp timestamp, \n");
		buffer.append("primary key (id) \n");
		buffer.append(" ) ");
		createTestTable(session, buffer.toString());
	}

	/**
	 * eXgpe[u𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @throws Exception ɗ\ʗOꍇɃX[܂
	 */
	private static void createTestPostgreSQLTable(DatabaseSession session) throws Exception {
		StringBuffer buffer = new StringBuffer();
		buffer.append("create table test ( \n");
		buffer.append("  id integer NOT NULL, \n");
		buffer.append("  general_text text, \n");
		buffer.append("  general_number integer, \n");
		buffer.append("  general_timestamp timestamp without time zone, \n");
		buffer.append("  c_char \"char\", \n");
		buffer.append("  c_abstime abstime, \n");
		buffer.append("  c_aclitem aclitem, \n");
		buffer.append("  c_bigint bigint, \n");
		buffer.append("  c_bit bit(1), \n");
		buffer.append("  c_bit_varying bit varying, \n");
		buffer.append("  c_boolean boolean, \n");
		buffer.append("  c_bytea bytea, \n");
		buffer.append("  c_character character(1), \n");
		buffer.append("  c_character_varying character varying, \n");
		buffer.append("  c_cid cid, \n");
		buffer.append("  c_cidr cidr, \n");
		buffer.append("  c_circle circle, \n");
		buffer.append("  c_date date, \n");
		buffer.append("  c_double_precision double precision, \n");
		buffer.append("  c_inet inet, \n");
		buffer.append("  c_integer integer, \n");
		buffer.append("  c_interval interval, \n");
		buffer.append("  c_macaddr macaddr, \n");
		buffer.append("  c_money money, \n");
		buffer.append("  c_numeric numeric, \n");
		buffer.append("  c_oid oid, \n");
		buffer.append("  c_path path, \n");
		buffer.append("  c_polygon polygon, \n");
		buffer.append("  c_real real, \n");
		buffer.append("  c_refcursor refcursor, \n");
		buffer.append("  c_regclass regclass, \n");
		buffer.append("  c_regoper regoper, \n");
		buffer.append("  c_regoperator regoperator, \n");
		buffer.append("  c_regproc regproc, \n");
		buffer.append("  c_regprocedure regprocedure, \n");
		buffer.append("  c_regtype regtype, \n");
		buffer.append("  c_reltime reltime, \n");
		buffer.append("  c_smallint smallint, \n");
		buffer.append("  c_smgr smgr, \n");
		buffer.append("  c_text text, \n");
		buffer.append("  c_tid tid, \n");
		buffer.append("  c_time_with_time_zone time with time zone, \n");
		buffer.append("  c_time_without_time_zone time without time zone, \n");
		buffer.append("  c_timestamp_with_time_zone timestamp with time zone, \n");
		buffer.append("  c_timestamp_without_time_zone timestamp without time zone, \n");
		buffer.append("  c_tinterval tinterval, \n");
		buffer.append("  c_chars \"char\"[], \n");
		buffer.append("  c_abstimes abstime[], \n");
		buffer.append("  c_aclitems aclitem[], \n");
		buffer.append("  c_bigints bigint[], \n");
		buffer.append("  c_bit_varyings bit varying[], \n");
		buffer.append("  c_bits bit(1)[], \n");
		buffer.append("  c_booleans boolean[], \n");
		buffer.append("  c_box box, \n");
		buffer.append("  c_boxs box[], \n");
		buffer.append("  c_byteas bytea[], \n");
		buffer.append("  c_character_varyings character varying[], \n");
		buffer.append("  c_characters character(1)[], \n");
		buffer.append("  c_cids cid[], \n");
		buffer.append("  c_cidrs cidr[], \n");
		buffer.append("  c_circles circle[], \n");
		buffer.append("  c_dates date[], \n");
		buffer.append("  c_double_precisions double precision[], \n");
		buffer.append("  c_inets inet[], \n");
		buffer.append("  c_int2vector int2vector, \n");
		buffer.append("  c_int2vectors int2vector[], \n");
		buffer.append("  c_integers integer[], \n");
		buffer.append("  c_intervals interval[], \n");
		buffer.append("  c_line line, \n");
		buffer.append("  c_lines line[], \n");
		buffer.append("  c_lseg lseg, \n");
		buffer.append("  c_lsegs lseg[], \n");
		buffer.append("  c_macaddrs macaddr[], \n");
		buffer.append("  c_moneys money[], \n");
		buffer.append("  c_name name, \n");
		buffer.append("  c_names name[], \n");
		buffer.append("  c_numerics numeric[], \n");
		buffer.append("  c_oids oid[], \n");
		buffer.append("  c_oidvector oidvector, \n");
		buffer.append("  c_oidvectors oidvector[], \n");
		buffer.append("  c_paths path[], \n");
		buffer.append("  c_point point, \n");
		buffer.append("  c_points point[], \n");
		buffer.append("  c_polygons polygon[], \n");
		buffer.append("  c_reals real[], \n");
		buffer.append("  c_refcursors refcursor[], \n");
		buffer.append("  c_regclasss regclass[], \n");
		buffer.append("  c_regopers regoper[], \n");
		buffer.append("  c_regoperators regoperator[], \n");
		buffer.append("  c_regprocs regproc[], \n");
		buffer.append("  c_regprocedures regprocedure[], \n");
		buffer.append("  c_regtypes regtype[], \n");
		buffer.append("  c_reltimes reltime[], \n");
		buffer.append("  c_smallints smallint[], \n");
		buffer.append("  c_texts text[], \n");
		buffer.append("  c_tids tid[], \n");
		buffer.append("  c_time_with_time_zones time with time zone[], \n");
		buffer.append("  c_time_without_time_zones time without time zone[], \n");
		buffer.append("  c_timestamp_with_time_zones timestamp with time zone[], \n");
		buffer.append("  c_timestamp_without_time_zones timestamp without time zone[], \n");
		buffer.append("  c_tintervals tinterval[], \n");
		buffer.append("  c_xids xid[], \n");
		buffer.append("  c_serial serial, \n");
		buffer.append("  c_bigserial bigserial, \n");
		buffer.append("  CONSTRAINT pk PRIMARY KEY (id) \n");
		buffer.append(")  \n");
		createTestTable(session, buffer.toString());
	}
}
