package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;

import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * Jev[gNX<br>
 * <br>
 * NXResultSetւ̒ڎQƍXV͍sꂸAɓƗ𑀍삵܂B<br>
 * [U[ɂēIuWFNg}ꂽ^C~OŎg̃IuWFNgƓ̏ێJIuWFNg
 * R[hANZXNXɐVKɔ܂BAAg̃IuWFNgQƂR[hANZXɑ}ł͂܂B<br>
 * ܂łIuWFNg̓ev[gNXƂĂ̈ʒuÂłAResultSetƂ̈ˑ֌W͔܂B<br>
 * AA`݂̂ResultSetւ̎QƂsAÓ͂̏Ɣrs܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultTemplateColumn extends ResultAccessorAbstract {

	/** J`IuWFNg */
	private ResultColumnDefinition definition;

	/** ʍsIuWFNg */
	private ResultTemplateRow row;

	/** JCfbNX */
	private int index = -1;

	/** JێIuWFNg */
	private Object value;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param row ʍsIuWFNg
	 * @param definition J`IuWFNg
	 * @param index Jʒu(0`)
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultTemplateColumn(ResultSet resultSet, ResultTemplateRow row, ResultColumnDefinition definition, int index) throws ResultSetAccessException,
			IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet, ResultAccessorState.TEMPLATE, null);
		this.definition = definition;
		this.row = row;
		this.index = index;
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * NX̓ev[gNXłׁA`݂̂̍XVs܂B<br>
	 * @param force `݂̂̍XVł邽߁AtOɊ֌WȂKXVs܂
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		definition.refreshResult();
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * NX̓ev[gNXłׁAResultSetւ̔f͍s邱Ƃ܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
	}

	// Public Method

	/**
	 * J`IuWFNg擾܂B<br>
	 * @return J`IuWFNg
	 */
	public ResultColumnDefinition getDefinition() {
		return definition;
	}

	/**
	 * JCfbNX擾܂B<br>
	 * @return JCfbNX
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * JێIuWFNg擾܂B<br>
	 * @return JێIuWFNg
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * JێIuWFNgݒ肵܂B<br>
	 * @param value JێIuWFNg
	 * @throws IllegalResultTypeException sȃR[h^CṽR[hɑ΂ĕύXsꍇɔ
	 */
	public void setValue(Object value) throws IllegalResultTypeException {
		this.value = value;
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return value == null ? null : value.toString();
	}
}
