package org.phosphoresce.commons.util;

import java.io.File;
import java.io.FileFilter;

import junit.framework.TestCase;

/**
 * FileUtilクラステストケース<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/06	Kitagawa		新規作成
 *-->
 */
public class TestFileUtil extends TestCase {

	public void testGetDirectories() throws Throwable {
		File base = new File("resources");
		FileFilter filter = new FileFilter() {

			public boolean accept(File file) {
				return !file.getName().endsWith("CVS");
			}
		};
		assertEquals(FileUtil.getDirectories(base, filter, false).length, 4);
		assertEquals(FileUtil.getDirectories(base, filter, true).length, 10);
	}

	public void testGetFiles() throws Throwable {
		File base = new File("resources");
		FileFilter filter = new FileFilter() {

			public boolean accept(File file) {
				return file.getName().endsWith("xml");
			}
		};

		assertEquals(FileUtil.getFiles(base, filter, false).length, 0);
		assertEquals(FileUtil.getFiles(base, filter, true).length, 3);
	}
}
