package org.phosphoresce.commons.util;

import java.io.File;
import java.util.Locale;

/**
 * Java keytoolユーティリティクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/05	Kitagawa		新規作成
 *-->
 */
public final class KeytoolUtil {

	/** keytoolコマンドパス */
	public static final String COMMAND_KEYTOOL = System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";

	/**
	 * コンストラクタ<br>
	 */
	private KeytoolUtil() {
		super();
	}

	/**
	 * 指定されたキーストアファイルが存在するか判定します。<br>
	 * @param keystore キーストアファイルパス
	 * @return キーストアファイルが存在する場合にtrueを返却
	 */
	public static boolean isExistKeyStore(String keystore) {
		File file = new File(keystore);
		return file.exists() && file.isFile();
	}

	/**
	 * 指定された情報でキーストアリソースを作成します。<br>
	 * @param alias エイリアス
	 * @param keyalg 暗号化アルゴリズム
	 * @param keysize キーサイズ
	 * @param keypass キーパスワード
	 * @param validity 有効期限
	 * @param storetype ストアタイプ
	 * @param keystore キーストアファイルパス
	 * @param storepass キーストアパスワード
	 * @param cn 姓名
	 * @param ou 組織単位名
	 * @param o 組織名
	 * @param c 国番号
	 * @return コマンド実行結果
	 */
	public static CommandResult genkey(String alias //
			, String keyalg//
			, int keysize //
			, String keypass //
			, int validity //
			, String storetype //
			, String keystore //
			, String storepass //
			, String cn //
			, String ou //
			, String o //
			, String c) {

		StringBuffer buffer = new StringBuffer();
		buffer.append(COMMAND_KEYTOOL);
		buffer.append(" -genkey ");
		buffer.append(" -alias ").append(alias);
		buffer.append(" -keyalg ").append(keyalg);
		buffer.append(" -keysize ").append(keysize);
		buffer.append(" -keypass ").append(keypass);
		buffer.append(" -validity ").append(validity);
		buffer.append(" -storetype ").append(storetype);
		buffer.append(" -keystore ").append(keystore);
		buffer.append(" -storepass ").append(storepass);
		buffer.append(" -dname ");
		buffer.append("\"");
		buffer.append("cn=").append(cn);
		buffer.append(",");
		buffer.append("ou=").append(ou);
		buffer.append(",");
		buffer.append("o=").append(o);
		buffer.append(",");
		buffer.append("c=").append(c);
		buffer.append("\"");

		return CommandUtil.execAndWait(buffer.toString());
	}

	/**
	 * 指定された情報でキーストアリソースを作成します。<br>
	 * 尚、以下の情報に関しては固定情報でキーストアが作成されます。<br>
	 * <ul>
	 * <li>キーアルゴリズム：RSA</li>
	 * <li>キーサイズ：512</li>
	 * <li>有効期限：365</li>
	 * <li>ストアタイプ：JKS</li>
	 * <li>国番号：Localが提供するディフォルト国番号</li>
	 * </ul>
	 * @param alias
	 * @param keypass
	 * @param keystore
	 * @param storepass
	 * @param cn
	 * @param ou
	 * @param o
	 * @return コマンド実行結果
	 */
	public static CommandResult genkey(String alias //
			, String keypass //
			, String keystore //
			, String storepass //
			, String cn //
			, String ou //
			, String o //
	) {
		return genkey(alias, "RSA", 512, keypass, 365, "JKS", keystore, storepass, cn, ou, o, Locale.getDefault().getCountry());
	}
}

