package org.phosphoresce.commons.html;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * HTMLドキュメントエレメントクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/19	Kitagawa		新規作成
 *-->
 */
public class HTMLDocumentElement extends HTMLElement {

	/**
	 * コンストラクタ<br>
	 */
	public HTMLDocumentElement() {
		super();
	}

	/**
	 * エレメントが子エレメントの操作をサポートしているか判定します。<br>
	 * @return HTMLDocumentElementは子エレメントをサポートするためtrueを返却
	 * @see org.phosphoresce.commons.html.HTMLElement#isSupportChild()
	 */
	public boolean isSupportChild() {
		return true;
	}

	/**
	 * 指定されたidのエレメントを取得します。<br>
	 * @param id エレメントid
	 * @return エレメントオブジェクト
	 */
	public HTMLTagElement getElementById(String id) {
		for (Iterator iterator = getChilds().iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object instanceof HTMLTagElement) {
				// 自身のエレメント検索
				HTMLTagElement element = (HTMLTagElement) object;
				if (id.equals(element.getAttribute("id"))) {
					return element;
				}
				// 子エレメント検索
				if (element.getChildCount() > 0) {
					for (int i = 0; i <= element.getChildCount() - 1; i++) {
						HTMLElement child = element.getChild(i);
						if (child instanceof HTMLTagElement) {
							HTMLTagElement childResult = ((HTMLTagElement) child).getElementById(id);
							if (childResult != null) {
								return childResult;
							}
						}
					}
				}
			}
		}
		return null;
	}

	/**
	 * 指定されたタグ名のエレメントを取得します。<br>
	 * @param tagName タグ名
	 * @return エレメントオブジェクト
	 */
	public HTMLTagElement[] getElementsByTagName(String tagName) {
		List list = new LinkedList();
		for (Iterator iterator = getChilds().iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object instanceof HTMLTagElement) {
				// 自身のエレメント検索
				HTMLTagElement element = (HTMLTagElement) object;
				if (tagName.equals(element.getName())) {
					list.add(element);
				}
				// 子エレメント検索
				if (element.getChildCount() > 0) {
					for (int i = 0; i <= element.getChildCount() - 1; i++) {
						HTMLElement child = element.getChild(i);
						if (child instanceof HTMLTagElement) {
							HTMLTagElement[] childResult = ((HTMLTagElement) child).getElementsByTagName(tagName);
							for (int j = 0; j <= childResult.length - 1; j++) {
								list.add(childResult[j]);
							}
						}
					}
				}
			}
		}
		return (HTMLTagElement[]) list.toArray(new HTMLTagElement[list.size()]);
	}

	/**
	 * 指定されたnameのエレメントを取得します。<br>
	 * @param name エレメントname
	 * @return エレメントオブジェクト
	 */
	public HTMLTagElement[] getElementsByName(String name) {
		List list = new LinkedList();
		for (Iterator iterator = getChilds().iterator(); iterator.hasNext();) {
			Object object = iterator.next();
			if (object instanceof HTMLTagElement) {
				// 自身のエレメント検索
				HTMLTagElement element = (HTMLTagElement) object;
				if (name.equals(element.getAttribute("name"))) {
					list.add(element);
				}
				// 子エレメント検索
				if (element.getChildCount() > 0) {
					for (int i = 0; i <= element.getChildCount() - 1; i++) {
						HTMLElement child = element.getChild(i);
						if (child instanceof HTMLTagElement) {
							HTMLTagElement[] childResult = ((HTMLTagElement) child).getElementsByName(name);
							for (int j = 0; j <= childResult.length - 1; j++) {
								list.add(childResult[j]);
							}
						}
					}
				}
			}
		}
		return (HTMLTagElement[]) list.toArray(new HTMLTagElement[list.size()]);
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(getChilds());
		return buffer.toString();
	}
}

