package org.phosphoresce.commons.html;


/**
 * HTMLコメントタグクラス<br>
 *
 * @author Kitagawa<br>
 *
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/19	Kitagawa		新規作成
 *-->
 */
public class HTMLCommentElement extends HTMLElement {

	/** コメント */
	private String comment;

	/**
	 * コンストラクタ<br>
	 */
	public HTMLCommentElement() {
		super();
		this.comment = null;
	}

	/**
	 * コンストラクタ<br>
	 * @param comment コメント
	 */
	public HTMLCommentElement(String comment) {
		super();
		this.comment = comment;
	}

	/**
	 * エレメントが子エレメントの操作をサポートしているか判定します。<br>
	 * @return HTMLCommentは子エレメントをサポートしないためfalseを返却
	 * @see org.phosphoresce.commons.html.HTMLElement#isSupportChild()
	 */
	public boolean isSupportChild() {
		return false;
	}

	/**
	 * コメントを取得します。<br>
	 * @return コメント
	 */
	public String getComment() {
		return comment;
	}

	/**
	 * コメントを設定します。<br>
	 * @param comment コメント
	 */
	public void setComment(String comment) {
		this.comment = comment;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("comment=");
		buffer.append(comment);
		buffer.append("}");
		return buffer.toString();
	}
}

