package org.phosphoresce.socket.proxy.http.servicetimeout.config;

import java.io.Serializable;

import org.phosphoresce.commons.util.StringUtil;

/**
 * HTTPリバースプロキシサービス時間外チェックプラグインコンテンツマッピング定義クラス<br>
 * <br>
 * 当クラスは特定のURL(正規表現)に合致するリクエストが行われた場合に
 * サービス時間外である旨のコンテンツを表示し、アプリケーションへのアクセスを
 * 許可させない為の定義を管理します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/29	Kitagawa		新規作成
 *-->
 */
public class ServiceTimeoutMappingConfig implements Serializable {

	/** マッピング対象URL正規表現 */
	private String matchUrl;

	/** サービス開始時間(hh:mm:ss) */
	private String serviceStartTime;

	/** サービス終了時間(hh:mm:ss) */
	private String serviceEndTime;

	/**
	 * コンストラクタ<br>
	 * @param matchUrl マッピング対象URL正規表現
	 */
	public ServiceTimeoutMappingConfig(String matchUrl) {
		super();
		this.matchUrl = matchUrl;
	}

	/**
	 * コンストラクタ<br>
	 */
	public ServiceTimeoutMappingConfig() {
		this(null);
	}

	/**
	 * マッピング対象URL正規表現を取得します。<br>
	 * @return マッピング対象URL正規表現
	 */
	public String getMatchUrl() {
		return StringUtil.nullsafe(matchUrl);
	}

	/**
	 * マッピング対象URL正規表現を設定します。<br>
	 * @param matchUrl マッピング対象URL正規表現
	 */
	public void setMatchUrl(String matchUrl) {
		this.matchUrl = matchUrl;
	}

	/**
	 * サービス開始時間(hh:mm:ss)を取得します。<br>
	 * @return サービス開始時間(hh:mm:ss)
	 */
	public String getServiceStartTime() {
		return StringUtil.nullsafe(serviceStartTime);
	}

	/**
	 * サービス開始時間(hh:mm:ss)を設定します。<br>
	 * @param serviceStartTime サービス開始時間(hh:mm:ss)
	 */
	public void setServiceStartTime(String serviceStartTime) {
		this.serviceStartTime = serviceStartTime;
	}

	/**
	 * サービス終了時間(hh:mm:ss)を取得します。<br>
	 * @return サービス終了時間(hh:mm:ss)
	 */
	public String getServiceEndTime() {
		return StringUtil.nullsafe(serviceEndTime);
	}

	/**
	 * サービス終了時間(hh:mm:ss)を設定します。<br>
	 * @param serviceEndTime サービス終了時間(hh:mm:ss)
	 */
	public void setServiceEndTime(String serviceEndTime) {
		this.serviceEndTime = serviceEndTime;
	}

	/**
	 * オブジェクトの文字列表現を返します。<br>
	 * @return オブジェクトの文字列表現
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("matchUrl=");
		buffer.append(matchUrl);
		buffer.append(",");
		buffer.append("serviceStartTime=");
		buffer.append(serviceStartTime);
		buffer.append(",");
		buffer.append("serviceEndTime=");
		buffer.append(serviceEndTime);
		buffer.append("}");
		return buffer.toString();
	}
}
