package org.phosphoresce.socket.proxy.http.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.phosphoresce.socket.proxy.http.HttpReverseProxyGlobal;

/**
 * HTTPリバースプロキシ共通ユーティリティクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/07	Kitagawa		新規作成
 *-->
 */
public final class HttpReverseProxyUtil {

	/**
	 * コンストラクタ<br>
	 */
	private HttpReverseProxyUtil() {
		super();
	}

	/**
	 * 指定された日付からヘッダ情報用の日付文字列を生成します。<br>
	 * @param date 日付オブジェクト
	 * @return ヘッダ情報用の日付文字列
	 */
	public static String createDateHeaderString(Date date) {
		SimpleDateFormat format = new SimpleDateFormat(HttpReverseProxyGlobal.HTTP_HEADER_DATE_FORMAT, Locale.ENGLISH);
		return format.format(date);
	}
}
