package org.phosphoresce.socket.proxy.http.util;

import java.io.InputStream;

import org.phosphoresce.commons.socket.http.HttpMimeMapping;
import org.phosphoresce.commons.socket.http.container.HttpSocketResponse;
import org.phosphoresce.socket.proxy.http.config.HttpReverseProxyConfig;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyControllerSession;
import org.phosphoresce.socket.proxy.http.session.HttpReverseProxyServerSession;

/**
 * HTTPリバースプロキシサーバーストリームレスポンスファクトリクラス<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/11/25	Kitagawa		新規作成
 *-->
 */
public class HttpReverseProxyStreamResponseFactory extends HttpReverseProxyResponseFactory {

	/** コンテンツオブジェクト */
	private InputStream content;

	/** MIMEタイプマッピング */
	private HttpMimeMapping mime;

	/**
	 * コンストラクタ<br>
	 * @param serverSession サーバーセッション
	 * @param controllerSession コントローラーセッション
	 */
	public HttpReverseProxyStreamResponseFactory(HttpReverseProxyServerSession serverSession, HttpReverseProxyControllerSession controllerSession) {
		super(serverSession, controllerSession);
	}

	/**
	 * コンストラクタ<br>
	 */
	public HttpReverseProxyStreamResponseFactory() {
		super(null, null);
	}

	/**
	 * レスポンスオブジェクトを生成します。<br>
	 * @return レスポンスオブジェクト
	 * @throws Throwable 正常にレスポンスオブジェクトを生成できなかった場合に発生
	 * @see org.phosphoresce.socket.proxy.http.util.HttpReverseProxyResponseFactory#create()
	 */
	public HttpSocketResponse create() throws Throwable {
		HttpReverseProxyConfig rConfig = HttpReverseProxyConfig.instance();

		HttpSocketResponse response = createRenderResponse();

		// MIMEタイプ設定
		if (mime != null) {
			if (mime.getMimeType().startsWith("text")) {
				response.addHeader("Content-Type", mime.getMimeType() + "; charset=" + rConfig.getServerContentCharset());
			} else {
				response.addHeader("Content-Type", mime.getMimeType());
			}
		}

		// コンテンツストリーム設定
		response.setContentStream(content);

		return response;
	}

	/**
	 * コンテンツオブジェクトを取得します。<br>
	 * @return コンテンツオブジェクト
	 */
	public InputStream getContent() {
		return content;
	}

	/**
	 * コンテンツオブジェクトを設定します。<br>
	 * @param content コンテンツオブジェクト
	 */
	public void setContent(InputStream content) {
		this.content = content;
	}

	/**
	 * コンテンツオブジェクトを設定します。<br>
	 * @param content コンテンツオブジェクト
	 * @param contentLength コンテンツデータ長
	 */
	public void setContent(InputStream content, int contentLength) {
		this.content = content;
		setContentLength(contentLength);
	}

	/**
	 * MIMEタイプマッピングを取得します。<br>
	 * @return MIMEタイプマッピング
	 */
	public HttpMimeMapping getMime() {
		return mime;
	}

	/**
	 * MIMEタイプマッピングを設定します。<br>
	 * @param mime MIMEタイプマッピング
	 */
	public void setMime(HttpMimeMapping mime) {
		this.mime = mime;
	}
}
