package org.phosphoresce.socket.proxy.http.session;

import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * HTTPリバースプロキシサーバーセッションクラス<br>
 * <br>
 * リバースプロキシサーバー起動中に永続的に保持する情報を管理します。<br>
 * プロキシコントロール処理毎に破棄される情報は当セッションでは保持せず、
 * HttpReverseProxyControllerSessionで保持します。<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * 更新日		更新者			更新内容
 * 2008/10/18	Kitagawa		新規作成
 *-->
 */
public final class HttpReverseProxyServerSession {

	/** ロギングオブジェクト */
	private Log log = LogFactory.getLog(getClass());

	/** サーバーソケット */
	private ServerSocket serverSocket;

	/** 各種データ情報保持マップ */
	private Map data;

	/**
	 * コンストラクタ<br>
	 */
	public HttpReverseProxyServerSession() {
		super();
		this.data = new HashMap();
	}

	/**
	 * サーバーソケットを取得します。<br>
	 * @return サーバーソケット
	 */
	public ServerSocket getServerSocket() {
		return serverSocket;
	}

	/**
	 * サーバーソケットを設定します。<br>
	 * @param serverSocket サーバーソケット
	 */
	public void setServerSocket(ServerSocket serverSocket) {
		this.serverSocket = serverSocket;
	}

	/**
	 * 指定されたキーでデータを設定します。<br>
	 * @param name データ保持キー
	 * @param object データオブジェクト
	 */
	public void setData(String name, Object object) {
		data.put(name, object);
	}

	/**
	 * 指定されたキーで保持されているデータを取得します。<br>
	 * @param name 保持キー
	 * @return データオブジェクト
	 */
	public Object getData(String name) {
		return data.get(name);
	}

	/**
	 * 指定されたキーで保持されているデータを削除します。<br>
	 * @param name 保持キー
	 */
	public void removeData(String name) {
		data.remove(name);
	}

	/**
	 * 指定されたキーでデータが保持されているか判定します。<br>
	 * @param name 保持キー
	 */
	public boolean containsData(String name) {
		return data.containsKey(name);
	}

}
